/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.shortcuts;

import com.atlassian.jira.pageobjects.JiraTestedProduct;
import com.atlassian.jira.pageobjects.components.DropDown;
import com.atlassian.jira.pageobjects.framework.util.TimedQueryFactory;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.shortcuts.DeleteShortcutDialog;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.shortcuts.EditShortcutDialog;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.inject.Inject;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Actions;

public class Shortcut {
    @Inject
    private PageBinder pageBinder;
    @Inject
    private JiraTestedProduct jira;
    @Inject
    private WebDriver webDriver;
    @Inject
    private TimedQueryFactory timedQueryFactory;
    private final PageElement backingElement;
    private PageElement link;
    private PageElement actionsTrigger;
    private PageElement icon;

    @Init
    public void init() {
        this.link = this.backingElement.find(By.className((String)"project-shortcuts-group__link"));
        this.actionsTrigger = this.backingElement.find(By.className((String)"project-shortcuts-group__actions"));
        this.icon = this.link.find(By.className((String)"aui-icon"));
    }

    public Shortcut(PageElement backingElement) {
        this.backingElement = backingElement;
    }

    public TimedQuery<String> getUrl() {
        return this.link.timed().getAttribute("href");
    }

    public TimedQuery<String> getName() {
        return this.link.find(By.className((String)"aui-nav-item-label")).timed().getText();
    }

    public TimedQuery<String> getIcon() {
        return this.icon.timed().getAttribute("data-project-shortcuts-icon-id");
    }

    public TimedCondition isIconPresent() {
        return this.icon.timed().isPresent();
    }

    public TimedCondition isIconVisible() {
        return this.icon.timed().isVisible();
    }

    public EditShortcutDialog edit() {
        this.getActionsDropdown().openAndClick(By.linkText((String)"Edit"));
        return (EditShortcutDialog)this.pageBinder.bind(EditShortcutDialog.class, new Object[0]);
    }

    public DeleteShortcutDialog delete() {
        this.getActionsDropdown().openAndClick(By.linkText((String)"Delete"));
        return (DeleteShortcutDialog)this.pageBinder.bind(DeleteShortcutDialog.class, new Object[0]);
    }

    private ActionsDropdown getActionsDropdown() {
        this.link.javascript().execute("arguments[0].scrollIntoView(true);", new Object[0]);
        WebDriverElement webDriverLink = (WebDriverElement)this.link;
        new Actions(this.webDriver).moveToElement(webDriverLink.asWebElement()).perform();
        new Actions(this.webDriver).moveToElement(webDriverLink.asWebElement(), 10, 0).perform();
        Poller.waitUntilTrue((TimedQuery)this.actionsTrigger.timed().isVisible());
        return (ActionsDropdown)((Object)this.pageBinder.bind(ActionsDropdown.class, new Object[]{this.actionsTrigger}));
    }

    public String open() {
        Assert.assertEquals((String)"Sanity check - we should have only one window opened", (long)1L, (long)this.webDriver.getWindowHandles().size());
        this.link.click();
        return this.getOpenedWindowUrlAndClose();
    }

    private String getOpenedWindowUrlAndClose() {
        String currentWindowHandle = this.webDriver.getWindowHandle();
        TimedQuery windowHandlesTimedQuery = this.timedQueryFactory.forSupplier(() -> this.webDriver.getWindowHandles());
        Set windowHandles = (Set)Poller.waitUntil((TimedQuery)windowHandlesTimedQuery, (Matcher)Matchers.hasSize((int)2));
        windowHandles.remove(currentWindowHandle);
        this.webDriver.switchTo().window((String)windowHandles.iterator().next());
        String url = (String)Poller.waitUntil((TimedQuery)this.timedQueryFactory.forSupplier(() -> this.webDriver.getCurrentUrl()), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"about:blank")));
        this.webDriver.close();
        this.webDriver.switchTo().window(currentWindowHandle);
        return url;
    }

    public static class ActionsDropdown
    extends DropDown {
        private final PageElement triggerElement;

        public ActionsDropdown(PageElement triggerElement) {
            super(null, By.cssSelector((String)".project-shortcuts-group .project-shortcuts-group__dropdown"));
            this.triggerElement = triggerElement;
        }

        protected PageElement trigger() {
            return this.triggerElement;
        }
    }
}

