/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.api.domain.TotalCount;
import com.atlassian.jira.rest.client.internal.async.AsynchronousSearchRestClient;
import com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import com.atlassian.jira.rest.client.internal.json.EnhancedSearchResultJsonParser;
import com.atlassian.jira.rest.client.internal.json.TotalCountJsonParser;
import io.atlassian.util.concurrent.Promise;
import java.net.URI;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class AsynchronousCloudSearchRestClient
extends AsynchronousSearchRestClient {
    private static final String SEARCH_URI_PREFIX = "search/jql";
    private static final String APPROXIMATE_COUNT_URI_PREFIX = "search/approximate-count";
    private static final String NEXT_PAGE_TOKEN_ATTRIBUTE = "nextPageToken";
    private static final String RECONCILE_ISSUES_ATTRIBUTE = "reconcileIssues";
    private static final String EXPAND = String.join((CharSequence)",", IssueRestClient.Expandos.SCHEMA.getValue(), IssueRestClient.Expandos.NAMES.getValue());
    private static final Set<String> DEFAULT_FIELDS = Set.of("*navigable");
    private final EnhancedSearchResultJsonParser searchResultJsonParser = new EnhancedSearchResultJsonParser();
    private final TotalCountJsonParser totalCountJsonParser = new TotalCountJsonParser();
    private final URI searchUri;
    private final URI totalCountUri;

    public AsynchronousCloudSearchRestClient(URI baseUri, DisposableHttpClient httpClient) {
        super(baseUri, httpClient);
        this.totalCountUri = UriBuilder.fromUri((URI)baseUri).path(APPROXIMATE_COUNT_URI_PREFIX).build(new Object[0]);
        this.searchUri = UriBuilder.fromUri((URI)baseUri).path(SEARCH_URI_PREFIX).build(new Object[0]);
    }

    @Override
    public Promise<SearchResult> searchJql(@Nullable String jql) {
        return this.searchJql(jql, null, null, DEFAULT_FIELDS);
    }

    @Override
    public Promise<SearchResult> searchJql(@Nullable String jql, @Nullable Integer maxResults, @Nullable Integer startAt, @Nullable Set<String> fields) {
        if (startAt == null || startAt == 0) {
            return this.enhancedSearchJql(jql, maxResults, null, fields, null);
        }
        throw new UnsupportedOperationException("This search API is not supported anymore. Please use this enhancedSearchJql");
    }

    @Override
    public Promise<SearchResult> enhancedSearchJql(@Nullable String jql) {
        return this.enhancedSearchJql(jql, null, null, DEFAULT_FIELDS, null);
    }

    @Override
    public Promise<SearchResult> enhancedSearchJql(@Nullable String jql, @Nullable Integer maxResults, @Nullable String nextPageToken, @Nullable Set<String> fields, @Nullable Set<Integer> reconcileIssues) {
        String notNullJql = StringUtils.defaultString((String)jql);
        if (notNullJql.length() > 500) {
            return this.enhancedSearchJqlImplPost(jql, maxResults, nextPageToken, fields, reconcileIssues);
        }
        return this.enhancedSearchJqlImplGet(jql, maxResults, nextPageToken, fields, reconcileIssues);
    }

    @Override
    public Promise<TotalCount> totalCount(String jql) {
        JSONObject postEntity = new JSONObject();
        try {
            postEntity.put("jql", (Object)jql);
        }
        catch (JSONException e) {
            throw new RestClientException((Throwable)e);
        }
        return this.postAndParse(this.totalCountUri, postEntity, this.totalCountJsonParser);
    }

    private Promise<SearchResult> enhancedSearchJqlImplGet(@Nullable String jql, @Nullable Integer maxResults, @Nullable String nextPageToken, Set<String> fields, @Nullable Set<Integer> reconcileIssues) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.searchUri).queryParam("jql", new Object[]{jql}).queryParam("expand", new Object[]{EXPAND});
        if (fields != null) {
            uriBuilder.queryParam("fields", new Object[]{String.join((CharSequence)",", fields)});
        }
        if (reconcileIssues != null) {
            uriBuilder.queryParam(RECONCILE_ISSUES_ATTRIBUTE, new Object[]{String.join((CharSequence)",", reconcileIssues.toString())});
        }
        this.addOptionalQueryParam(uriBuilder, NEXT_PAGE_TOKEN_ATTRIBUTE, nextPageToken);
        this.addOptionalQueryParam(uriBuilder, "maxResults", maxResults);
        return this.getAndParse(uriBuilder.build(new Object[0]), this.searchResultJsonParser);
    }

    private Promise<SearchResult> enhancedSearchJqlImplPost(@Nullable String jql, @Nullable Integer maxResults, @Nullable String nextPageToken, @Nullable Set<String> fields, @Nullable Set<Integer> reconcileIssues) {
        JSONObject postEntity = new JSONObject();
        try {
            postEntity.put("jql", (Object)jql).put("expand", (Object)EXPAND).putOpt("maxResults", (Object)maxResults).putOpt(NEXT_PAGE_TOKEN_ATTRIBUTE, (Object)nextPageToken);
            if (fields != null) {
                postEntity.put("fields", fields);
            }
            if (reconcileIssues != null) {
                postEntity.put(RECONCILE_ISSUES_ATTRIBUTE, reconcileIssues);
            }
        }
        catch (JSONException e) {
            throw new RestClientException((Throwable)e);
        }
        return this.postAndParse(this.searchUri, postEntity, this.searchResultJsonParser);
    }
}

