/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.SearchRestClient;
import com.atlassian.jira.rest.client.api.domain.Filter;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.api.domain.TotalCount;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.FilterJsonParser;
import com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import com.atlassian.jira.rest.client.internal.json.SearchResultJsonParser;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.Promise;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class AsynchronousSearchRestClient
extends AbstractAsynchronousRestClient
implements SearchRestClient {
    private static final Function<IssueRestClient.Expandos, String> EXPANDO_TO_PARAM = new Function<IssueRestClient.Expandos, String>(){

        public String apply(IssueRestClient.Expandos from) {
            return from.name().toLowerCase();
        }
    };
    private static final String START_AT_ATTRIBUTE = "startAt";
    private static final String FILTER_FAVOURITE_PATH = "filter/favourite";
    private static final String FILTER_PATH_FORMAT = "filter/%s";
    private static final String SEARCH_URI_PREFIX = "search";
    protected static final String MAX_RESULTS_ATTRIBUTE = "maxResults";
    protected static final int MAX_JQL_LENGTH_FOR_HTTP_GET = 500;
    protected static final String JQL_ATTRIBUTE = "jql";
    protected static final String EXPAND_ATTRIBUTE = "expand";
    protected static final String FIELDS_ATTRIBUTE = "fields";
    private final SearchResultJsonParser searchResultJsonParser = new SearchResultJsonParser();
    private final FilterJsonParser filterJsonParser = new FilterJsonParser();
    private final GenericJsonArrayParser<Filter> filtersParser = GenericJsonArrayParser.create(new FilterJsonParser());
    private final URI searchUri;
    private final URI favouriteUri;
    private final URI baseUri;

    public AsynchronousSearchRestClient(URI baseUri, HttpClient asyncHttpClient) {
        super(asyncHttpClient);
        this.baseUri = baseUri;
        this.searchUri = UriBuilder.fromUri((URI)baseUri).path(SEARCH_URI_PREFIX).build(new Object[0]);
        this.favouriteUri = UriBuilder.fromUri((URI)baseUri).path(FILTER_FAVOURITE_PATH).build(new Object[0]);
    }

    public Promise<SearchResult> searchJql(@Nullable String jql) {
        return this.searchJql(jql, null, null, null);
    }

    public Promise<SearchResult> searchJql(@Nullable String jql, @Nullable Integer maxResults, @Nullable Integer startAt, @Nullable Set<String> fields) {
        Iterable expandosValues = Iterables.transform((Iterable)ImmutableList.of((Object)IssueRestClient.Expandos.SCHEMA, (Object)IssueRestClient.Expandos.NAMES), EXPANDO_TO_PARAM);
        String notNullJql = StringUtils.defaultString((String)jql);
        if (notNullJql.length() > 500) {
            return this.searchJqlImplPost(maxResults, startAt, expandosValues, notNullJql, fields);
        }
        return this.searchJqlImplGet(maxResults, startAt, expandosValues, notNullJql, fields);
    }

    public Promise<SearchResult> enhancedSearchJql(@Nullable String jql) {
        throw new UnsupportedOperationException("This search API is not supported in DC. Please use searchJql for DC");
    }

    public Promise<SearchResult> enhancedSearchJql(@Nullable String jql, @Nullable Integer maxResults, @Nullable String nextPageToken, @Nullable Set<String> fields, @Nullable Set<Integer> reconcileIssues) {
        throw new UnsupportedOperationException("This search API is not supported in DC. Please use searchJql for DC");
    }

    public Promise<TotalCount> totalCount(String jql) {
        throw new UnsupportedOperationException("This search API is not supported in DC.");
    }

    protected Promise<SearchResult> searchJqlImplGet(@Nullable Integer maxResults, @Nullable Integer startAt, Iterable<String> expandosValues, String jql, @Nullable Set<String> fields) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.searchUri).queryParam(JQL_ATTRIBUTE, new Object[]{jql}).queryParam(EXPAND_ATTRIBUTE, new Object[]{Joiner.on((String)",").join(expandosValues)});
        if (fields != null) {
            uriBuilder.queryParam(FIELDS_ATTRIBUTE, new Object[]{Joiner.on((String)",").join(fields)});
        }
        this.addOptionalQueryParam(uriBuilder, MAX_RESULTS_ATTRIBUTE, maxResults);
        this.addOptionalQueryParam(uriBuilder, START_AT_ATTRIBUTE, startAt);
        return this.getAndParse(uriBuilder.build(new Object[0]), this.searchResultJsonParser);
    }

    protected void addOptionalQueryParam(UriBuilder uriBuilder, String key, Object ... values) {
        if (values != null && values.length > 0 && values[0] != null) {
            uriBuilder.queryParam(key, values);
        }
    }

    private Promise<SearchResult> searchJqlImplPost(@Nullable Integer maxResults, @Nullable Integer startAt, Iterable<String> expandosValues, String jql, @Nullable Set<String> fields) {
        JSONObject postEntity = new JSONObject();
        try {
            postEntity.put(JQL_ATTRIBUTE, (Object)jql).put(EXPAND_ATTRIBUTE, (Collection)ImmutableList.copyOf(expandosValues)).putOpt(START_AT_ATTRIBUTE, (Object)startAt).putOpt(MAX_RESULTS_ATTRIBUTE, (Object)maxResults);
            if (fields != null) {
                postEntity.put(FIELDS_ATTRIBUTE, fields);
            }
        }
        catch (JSONException e) {
            throw new RestClientException((Throwable)e);
        }
        return this.postAndParse(this.searchUri, postEntity, this.searchResultJsonParser);
    }

    public Promise<Iterable<Filter>> getFavouriteFilters() {
        return this.getAndParse(this.favouriteUri, this.filtersParser);
    }

    public Promise<Filter> getFilter(URI filterUri) {
        return this.getAndParse(filterUri, this.filterJsonParser);
    }

    public Promise<Filter> getFilter(long id) {
        return this.getFilter(UriBuilder.fromUri((URI)this.baseUri).path(String.format(FILTER_PATH_FORMAT, id)).build(new Object[0]));
    }
}

