/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class RestClientException
extends RuntimeException {
    private final Collection<String> errorMessages;
    private final Optional<Integer> statusCode;

    public RestClientException(Throwable cause) {
        super(cause);
        this.errorMessages = Collections.emptyList();
        this.statusCode = Optional.absent();
    }

    public RestClientException(Throwable cause, int statusCode) {
        super(cause);
        this.errorMessages = Collections.emptyList();
        this.statusCode = Optional.of((Object)statusCode);
    }

    public RestClientException(String errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.errorMessages = Arrays.asList(errorMessage);
        this.statusCode = Optional.absent();
    }

    public RestClientException(Collection<String> errorMessages, int statusCode) {
        super(Joiner.on((String)"\n").join(errorMessages));
        this.errorMessages = new ArrayList<String>(errorMessages);
        this.statusCode = Optional.of((Object)statusCode);
    }

    public RestClientException(Collection<String> errorMessages, Throwable cause, int statusCode) {
        super(Joiner.on((String)"\n").join(errorMessages), cause);
        this.errorMessages = new ArrayList<String>(errorMessages);
        this.statusCode = Optional.of((Object)statusCode);
    }

    public Iterable<String> getErrorMessages() {
        return this.errorMessages;
    }

    public Optional<Integer> getStatusCode() {
        return this.statusCode;
    }
}

