/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.AuthenticationHandler;
import com.atlassian.jira.rest.client.ComponentRestClient;
import com.atlassian.jira.rest.client.IssueRestClient;
import com.atlassian.jira.rest.client.JiraRestClient;
import com.atlassian.jira.rest.client.MetadataRestClient;
import com.atlassian.jira.rest.client.ProjectRestClient;
import com.atlassian.jira.rest.client.ProjectRolesRestClient;
import com.atlassian.jira.rest.client.SearchRestClient;
import com.atlassian.jira.rest.client.SessionRestClient;
import com.atlassian.jira.rest.client.UserRestClient;
import com.atlassian.jira.rest.client.VersionRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousComponentRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousHttpClientFactory;
import com.atlassian.jira.rest.client.internal.async.AsynchronousIssueRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousMetadataRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousProjectRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousProjectRolesRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousSearchRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousSessionRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousUserRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousVersionRestClient;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

public class AsynchronousJiraRestClient
implements JiraRestClient {
    private final IssueRestClient issueRestClient;
    private final SessionRestClient sessionRestClient;
    private final UserRestClient userRestClient;
    private final ProjectRestClient projectRestClient;
    private final ComponentRestClient componentRestClient;
    private final MetadataRestClient metadataRestClient;
    private final SearchRestClient searchRestClient;
    private final VersionRestClient versionRestClient;
    private final ProjectRolesRestClient projectRolesRestClient;

    public AsynchronousJiraRestClient(URI serverUri, AuthenticationHandler authenticationHandler) {
        this(serverUri, new AsynchronousHttpClientFactory().createClient(serverUri, authenticationHandler));
    }

    public AsynchronousJiraRestClient(URI serverUri, HttpClient httpClient) {
        URI baseUri = UriBuilder.fromUri((URI)serverUri).path("/rest/api/latest").build(new Object[0]);
        this.metadataRestClient = new AsynchronousMetadataRestClient(baseUri, httpClient);
        this.sessionRestClient = new AsynchronousSessionRestClient(serverUri, httpClient);
        this.issueRestClient = new AsynchronousIssueRestClient(baseUri, httpClient, this.sessionRestClient, this.metadataRestClient);
        this.userRestClient = new AsynchronousUserRestClient(baseUri, httpClient);
        this.projectRestClient = new AsynchronousProjectRestClient(baseUri, httpClient);
        this.componentRestClient = new AsynchronousComponentRestClient(baseUri, httpClient);
        this.searchRestClient = new AsynchronousSearchRestClient(baseUri, httpClient);
        this.versionRestClient = new AsynchronousVersionRestClient(baseUri, httpClient);
        this.projectRolesRestClient = new AsynchronousProjectRolesRestClient(httpClient, serverUri);
    }

    @Override
    public IssueRestClient getIssueClient() {
        return this.issueRestClient;
    }

    @Override
    public SessionRestClient getSessionClient() {
        return this.sessionRestClient;
    }

    @Override
    public UserRestClient getUserClient() {
        return this.userRestClient;
    }

    @Override
    public ProjectRestClient getProjectClient() {
        return this.projectRestClient;
    }

    @Override
    public ComponentRestClient getComponentClient() {
        return this.componentRestClient;
    }

    @Override
    public MetadataRestClient getMetadataClient() {
        return this.metadataRestClient;
    }

    @Override
    public SearchRestClient getSearchClient() {
        return this.searchRestClient;
    }

    @Override
    public VersionRestClient getVersionRestClient() {
        return this.versionRestClient;
    }

    @Override
    public ProjectRolesRestClient getProjectRolesRestClient() {
        return this.projectRolesRestClient;
    }
}

