/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.property;

import com.atlassian.jira.rest.api.property.PropertiesBeanSerializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(using=PropertiesBeanSerializer.class)
public class PropertiesBean {
    public static final PropertiesBean EMPTY = PropertiesBean.of(Collections.emptyMap());
    private final Map<String, String> properties;

    public static PropertiesBean of(Map<String, String> properties) {
        return new PropertiesBean(properties);
    }

    private PropertiesBean(Map<String, String> properties) {
        this.properties = properties != null ? ImmutableMap.copyOf(properties) : null;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertiesBean that = (PropertiesBean)o;
        return Objects.equal(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.properties});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("properties", this.properties).toString();
    }
}

