/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.filter.scope;

import com.atlassian.jira.rest.filter.scope.RequestScope;
import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;

@Provider
@PreMatching
public class RequestScopeFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private final RequestScope scope;

    @Inject
    public RequestScopeFilter(RequestScope scope) {
        this.scope = scope;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        this.scope.beginRequest(requestContext);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        RequestScope.Request currentRequest = this.scope.currentRequest();
        if (currentRequest != null) {
            currentRequest.destroy();
        }
    }
}

