/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.attachment;

import com.atlassian.core.util.FileSize;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.AttachmentError;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachment;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.internal.common.bean.AttachTemporaryFileBadResultBean;
import com.atlassian.jira.rest.internal.common.bean.AttachTemporaryFileGoodResultBean;
import com.atlassian.jira.rest.util.AttachmentHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.SecureUserTokenManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.security.annotation.CorsAllowed;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Either;
import java.io.InputStream;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import webwork.config.Configuration;

@Path(value="AttachTemporaryFile")
@Produces(value={"application/json"})
@UnrestrictedAccess
@CorsAllowed
public class AttachTemporaryFileResource {
    private static final Logger log = Logger.getLogger(AttachTemporaryFileResource.class);
    private final JiraAuthenticationContext authContext;
    private final TemporaryWebAttachmentManager temporaryWebAttachmentManager;
    private final IssueService issueService;
    private final ProjectService projectService;
    private final XsrfTokenGenerator xsrfGenerator;
    private final AttachmentHelper attachmentHelper;
    private final SecureUserTokenManager secureUserTokenManager;

    @Inject
    public AttachTemporaryFileResource(JiraAuthenticationContext authContext, TemporaryWebAttachmentManager temporaryWebAttachmentManager, IssueService issueService, ProjectService projectService, XsrfTokenGenerator xsrfGenerator, AttachmentHelper attachmentHelper, SecureUserTokenManager secureUserTokenManager) {
        this.authContext = authContext;
        this.temporaryWebAttachmentManager = temporaryWebAttachmentManager;
        this.issueService = issueService;
        this.projectService = projectService;
        this.xsrfGenerator = xsrfGenerator;
        this.attachmentHelper = attachmentHelper;
        this.secureUserTokenManager = secureUserTokenManager;
    }

    @POST
    @Consumes(value={"*/*"})
    @Path(value="/secure")
    public Response addTemporaryAttachment(@QueryParam(value="filename") String filename, @QueryParam(value="projectId") Long projectId, @QueryParam(value="issueId") Long issueId, @QueryParam(value="size") Long size, @QueryParam(value="secureToken") String secureToken, @QueryParam(value="formToken") String formToken, @Context HttpServletRequest request) {
        try {
            if (secureToken == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
            }
            ApplicationUser secureUser = this.secureUserTokenManager.useToken(secureToken, SecureUserTokenManager.TokenType.SCREENSHOT);
            if (secureUser == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.never()).build();
            }
            this.authContext.setLoggedInUser(secureUser);
        }
        catch (RuntimeException e) {
            this.quietlyCloseInputStream(request);
            throw e;
        }
        return this.addTemporaryAttachment(filename, projectId, issueId, size, formToken, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"*/*"})
    public Response addTemporaryAttachment(@QueryParam(value="filename") String filename, @QueryParam(value="projectId") Long projectId, @QueryParam(value="issueId") Long issueId, @QueryParam(value="size") Long size, final @QueryParam(value="formToken") String formToken, @Context HttpServletRequest request) {
        try {
            if (formToken == null) {
                Response response = AttachTemporaryFileResource.createError(Response.Status.BAD_REQUEST, this.getI18n().getText("rest.common.missing.required.param", "formToken"));
                return response;
            }
            AttachmentHelper.ValidationResult validationResult = this.attachmentHelper.validate(request, filename, size);
            if (!validationResult.isValid()) {
                switch (validationResult.getErrorType()) {
                    case ATTACHMENT_TO_LARGE: {
                        String message = this.getI18n().getText("upload.too.big", filename, FileSize.format((long)validationResult.getSize()), FileSize.format((Long)new Long(Configuration.getString((String)"webwork.multipart.maxSize"))));
                        Response response = AttachTemporaryFileResource.createError(Response.Status.BAD_REQUEST, message);
                        return response;
                    }
                    case ATTACHMENT_IO_SIZE: {
                        String message = this.getI18n().getText("attachfile.error.io.size", filename);
                        Response response = AttachTemporaryFileResource.createError(Response.Status.BAD_REQUEST, message);
                        return response;
                    }
                    case ATTACHMENT_IO_UNKNOWN: {
                        String message = this.getI18n().getText("attachfile.error.io.error", filename, validationResult.getErrorMessage());
                        Response response = AttachTemporaryFileResource.createError(Response.Status.INTERNAL_SERVER_ERROR, message);
                        return response;
                    }
                    case FILENAME_BLANK: {
                        Response message = Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
                        return message;
                    }
                    case XSRF_TOKEN_INVALID: {
                        Response message = this.createTokenError(this.xsrfGenerator.generateToken(request));
                        return message;
                    }
                }
                log.error((Object)("Got unknown validation error: " + (Object)((Object)validationResult.getErrorType())));
                Response message = AttachTemporaryFileResource.createError(Response.Status.INTERNAL_SERVER_ERROR, this.getI18n().getText("attachment.error.unknown", filename));
                return message;
            }
            if (issueId == null && projectId == null) {
                Response message = Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
                return message;
            }
            ApplicationUser user = this.authContext.getUser();
            Either<Issue, Project> target = this.getAttachmentTarget(projectId, issueId, user);
            Either createResult = this.temporaryWebAttachmentManager.createTemporaryWebAttachment(validationResult.getInputStream(), filename, validationResult.getContentType(), validationResult.getSize(), target, formToken, user);
            Response response = (Response)createResult.fold((java.util.function.Function)new Function<AttachmentError, Response>(){

                public Response apply(AttachmentError error) {
                    return AttachTemporaryFileResource.createError(Response.Status.INTERNAL_SERVER_ERROR, error.getLocalizedMessage());
                }
            }, (java.util.function.Function)new Function<TemporaryWebAttachment, Response>(){

                public Response apply(TemporaryWebAttachment attachment) {
                    return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new AttachTemporaryFileGoodResultBean(attachment.getStringId(), attachment.getFilename(), formToken)).cacheControl(CacheControl.never()).build();
                }
            });
            return response;
        }
        finally {
            this.quietlyCloseInputStream(request);
        }
    }

    private I18nHelper getI18n() {
        return this.authContext.getI18nHelper();
    }

    private void quietlyCloseInputStream(HttpServletRequest request) {
        try {
            IOUtils.closeQuietly((InputStream)request.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Either<Issue, Project> getAttachmentTarget(Long projectId, Long issueId, ApplicationUser user) {
        if (issueId == null) {
            return Either.right((Object)this.getProject(user, projectId));
        }
        return Either.left((Object)this.getIssue(user, issueId));
    }

    private Issue getIssue(ApplicationUser user, Long id) {
        return this.throw404WhenInvalid(this.issueService.getIssue(user, id)).getIssue();
    }

    private <T extends ServiceResult> T throw404WhenInvalid(T serviceResult) {
        if (!serviceResult.isValid()) {
            throw new WebApplicationException(AttachTemporaryFileResource.createError(Response.Status.NOT_FOUND, serviceResult.getErrorCollection()));
        }
        return serviceResult;
    }

    private Project getProject(ApplicationUser user, Long id) {
        return this.throw404WhenInvalid(this.projectService.getProjectById(user, id)).getProject();
    }

    private static Response createError(Response.Status status, ErrorCollection collection) {
        String message = (String)Iterables.getFirst((Iterable)collection.getErrorMessages(), null);
        if (message == null) {
            message = (String)Iterables.getFirst(collection.getErrors().values(), null);
        }
        return AttachTemporaryFileResource.createError(status, message);
    }

    private static Response createError(Response.Status status, String message) {
        return Response.status((Response.Status)status).cacheControl(CacheControl.never()).entity((Object)new AttachTemporaryFileBadResultBean(message)).build();
    }

    private Response createTokenError(String newToken) {
        String message = this.getI18n().getText("attachfile.xsrf.try.again");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).entity((Object)new AttachTemporaryFileBadResultBean(message, newToken)).build();
    }
}

