/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.field.configscheme;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.issue.fields.FieldConfigSchemeParameters;
import com.atlassian.jira.bc.issue.fields.FieldConfigSchemeService;
import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.internal.v2.field.configscheme.AvailableIssueTypesRequestBean;
import com.atlassian.jira.rest.internal.v2.field.configscheme.AvailableProjectsBean;
import com.atlassian.jira.rest.internal.v2.field.configscheme.AvailableProjectsRequestBean;
import com.atlassian.jira.rest.internal.v2.field.configscheme.FieldConfigSchemeBean;
import com.atlassian.jira.rest.internal.v2.field.configscheme.FieldConfigSchemeBeanFactory;
import com.atlassian.jira.rest.util.IssueTypeConverter;
import com.atlassian.jira.rest.util.ProjectConverter;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;

@Path(value="field/{fieldId}/context")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FieldConfigSchemeResource {
    private static final int DEFAULT_MAX_LIMIT = 100;
    private static final String MAX_RESULTS_TOO_LOW = "Max results value cannot be lower than 0";
    private final FieldConfigSchemeService fieldConfigSchemeService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final FieldConfigSchemeBeanFactory fieldConfigSchemeBeanFactory;
    private final IssueTypeConverter issueTypeConverter;
    private final IssueTypeService issueTypeService;
    private final ProjectConverter projectConverter;
    private final JiraBaseUrls jiraBaseUrls;

    @Inject
    public FieldConfigSchemeResource(@ComponentImport FieldConfigSchemeService fieldConfigSchemeService, JiraAuthenticationContext jiraAuthenticationContext, FieldConfigSchemeBeanFactory configSchemeBeanFactory, IssueTypeConverter issueTypeConverter, IssueTypeService issueTypeService, ProjectConverter projectConverter, JiraBaseUrls jiraBaseUrls) {
        this.fieldConfigSchemeService = fieldConfigSchemeService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.fieldConfigSchemeBeanFactory = configSchemeBeanFactory;
        this.issueTypeConverter = issueTypeConverter;
        this.issueTypeService = issueTypeService;
        this.projectConverter = projectConverter;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @GET
    @Path(value="{configSchemeId}")
    public Response getFieldConfigScheme(@PathParam(value="fieldId") String fieldId, @PathParam(value="configSchemeId") Long configSchemeId) {
        ServiceOutcome result = this.fieldConfigSchemeService.getFieldConfigScheme(this.jiraAuthenticationContext.getLoggedInUser(), fieldId, configSchemeId.longValue());
        return Response.ok((Object)this.fieldConfigSchemeBeanFactory.getBean((FieldConfigScheme)FieldConfigSchemeResource.checkResult(result))).build();
    }

    @GET
    public Response getFieldConfigSchemes(@PathParam(value="fieldId") String fieldId) {
        ServiceOutcome result = this.fieldConfigSchemeService.getFieldConfigSchemesForField(this.jiraAuthenticationContext.getLoggedInUser(), fieldId);
        return Response.ok(this.fieldConfigSchemeBeanFactory.getBeans((List)FieldConfigSchemeResource.checkResult(result))).build();
    }

    @POST
    public Response createFieldConfigScheme(@PathParam(value="fieldId") String fieldId, FieldConfigSchemeBean input) {
        ServiceOutcome<FieldConfigSchemeParameters> paramters = this.beanToParameters(null, fieldId, input);
        ServiceOutcome result = this.fieldConfigSchemeService.createFieldConfigScheme(this.jiraAuthenticationContext.getLoggedInUser(), FieldConfigSchemeResource.checkResult(paramters));
        return Response.ok((Object)this.fieldConfigSchemeBeanFactory.getBean((FieldConfigScheme)FieldConfigSchemeResource.checkResult(result))).build();
    }

    @PUT
    @Path(value="{configSchemeId}")
    public Response updateFieldConfigScheme(@PathParam(value="fieldId") String fieldId, @PathParam(value="configSchemeId") long configSchemeId, FieldConfigSchemeBean input) {
        ServiceOutcome existingScheme = this.fieldConfigSchemeService.getFieldConfigScheme(this.jiraAuthenticationContext.getLoggedInUser(), fieldId, configSchemeId);
        ServiceOutcome<FieldConfigSchemeParameters> parameters = this.beanToParameters((FieldConfigScheme)FieldConfigSchemeResource.checkResult(existingScheme), fieldId, input);
        ServiceOutcome result = this.fieldConfigSchemeService.updateFieldConfigScheme(this.jiraAuthenticationContext.getLoggedInUser(), FieldConfigSchemeResource.checkResult(parameters));
        return Response.ok((Object)this.fieldConfigSchemeBeanFactory.getBean((FieldConfigScheme)FieldConfigSchemeResource.checkResult(result))).build();
    }

    private ServiceOutcome<FieldConfigSchemeParameters> beanToParameters(@Nullable FieldConfigScheme existingScheme, String fieldId, FieldConfigSchemeBean input) {
        FieldConfigScheme fieldConfigScheme = existingScheme != null ? this.fieldConfigSchemeBeanFactory.updateConfig(fieldId, existingScheme, input) : this.fieldConfigSchemeBeanFactory.createConfig(fieldId, input);
        FieldConfigSchemeParameters.Builder builder = FieldConfigSchemeParameters.withScheme((FieldConfigScheme)fieldConfigScheme);
        if (input.isAllIssueTypes()) {
            builder = builder.anyIssueType();
        } else if (input.getIssueTypes() != null) {
            ServiceOutcome<List<IssueType>> issueTypes = this.issueTypeConverter.all(input.getIssueTypes());
            if (!issueTypes.isValid()) {
                return ServiceOutcomeImpl.from((com.atlassian.jira.util.ErrorCollection)issueTypes.getErrorCollection());
            }
            builder = builder.issueTypes((Collection)issueTypes.get());
        } else {
            throw new RESTException(Response.Status.BAD_REQUEST, new String[0]);
        }
        if (input.isAllProjects()) {
            builder = builder.allProjects();
        } else if (input.getProjects() != null) {
            ServiceOutcome<List<Project>> projects = this.projectConverter.all(input.getProjects());
            if (!projects.isValid()) {
                return ServiceOutcomeImpl.from((com.atlassian.jira.util.ErrorCollection)projects.getErrorCollection());
            }
            builder = builder.projects((Collection)projects.get());
        } else {
            throw new RESTException(Response.Status.BAD_REQUEST, new String[0]);
        }
        builder.defaultValue(input.getDefaultValue());
        return ServiceOutcomeImpl.ok((Object)builder.build());
    }

    @DELETE
    @Path(value="{configSchemeId}")
    public Response removeFieldConfigScheme(@PathParam(value="fieldId") String fieldId, @PathParam(value="configSchemeId") Long configSchemeId) {
        ServiceResult result = this.fieldConfigSchemeService.deleteFieldConfigScheme(this.jiraAuthenticationContext.getLoggedInUser(), fieldId, configSchemeId.longValue());
        if (result.isValid()) {
            return Response.ok((Object)ImmutableMap.of()).build();
        }
        throw new RESTException(ErrorCollection.of(result.getErrorCollection()));
    }

    @POST
    @Path(value="{configSchemeId}/availableProjects")
    public Response getAvailableProjectsForUpdateScheme(@PathParam(value="fieldId") String fieldId, @PathParam(value="configSchemeId") Long configSchemeId, @QueryParam(value="query") @DefaultValue(value="") String query, @QueryParam(value="startAt") @DefaultValue(value="0") Long startAt, @QueryParam(value="maxResults") @DefaultValue(value="100") int maxResults, AvailableProjectsRequestBean request) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (maxResults <= 0) {
            errors.addErrorMessage(MAX_RESULTS_TOO_LOW);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errors)).build();
        }
        AvailableProjectsPaginatedBean result = this.buildPaginatedAvailableProjects(user, fieldId, Optional.of(configSchemeId), startAt, maxResults, query, request.getIgnoredProjectIds());
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="availableProjects")
    public Response getAvailableProjectsForCreateScheme(@PathParam(value="fieldId") String fieldId, @QueryParam(value="query") @DefaultValue(value="") String query, @QueryParam(value="startAt") @DefaultValue(value="0") Long startAt, @QueryParam(value="maxResults") @DefaultValue(value="100") int maxResults, AvailableProjectsRequestBean request) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (maxResults <= 0) {
            errors.addErrorMessage(MAX_RESULTS_TOO_LOW);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errors)).build();
        }
        AvailableProjectsPaginatedBean result = this.buildPaginatedAvailableProjects(user, fieldId, Optional.empty(), startAt, maxResults, query, request.getIgnoredProjectIds());
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="availableIssueTypes")
    public Response getAvailableIssueTypes(@QueryParam(value="query") @DefaultValue(value="") String query, @QueryParam(value="startAt") @DefaultValue(value="0") Long startAt, @QueryParam(value="maxResults") @DefaultValue(value="100") int maxResults, AvailableIssueTypesRequestBean request) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (maxResults <= 0) {
            errors.addErrorMessage(MAX_RESULTS_TOO_LOW);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errors)).build();
        }
        List availableIssueTypes = this.issueTypeService.findIssueTypes(user, query).filter(issueType -> !request.getIgnoredIssueTypeIds().contains(issueType.getId())).collect(Collectors.toList());
        PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)maxResults);
        Page page = Pages.toPage(availableIssueTypes, (PageRequest)pageRequest);
        PageBean<IssueTypeJsonBean> result = PageBean.from(pageRequest, page).build(issueType -> IssueTypeJsonBean.shortBean((IssueType)issueType, (JiraBaseUrls)this.jiraBaseUrls));
        return Response.ok(result).build();
    }

    private static <T> T checkResult(ServiceOutcome<T> outcome) {
        if (outcome.isValid()) {
            return (T)outcome.get();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    private AvailableProjectsPaginatedBean buildPaginatedAvailableProjects(ApplicationUser user, String fieldId, Optional<Long> configSchemeId, Long startAt, int maxResults, String query, Set<String> ignoredProjectIds) {
        boolean isIntentUpdate = configSchemeId.isPresent();
        List<String> queryTerms = Arrays.asList(query.toLowerCase().split("\\s"));
        ServiceOutcome availableProjects = isIntentUpdate ? this.fieldConfigSchemeService.getAvailableProjectsForUpdate(user, fieldId, configSchemeId.get().longValue()) : this.fieldConfigSchemeService.getAvailableProjectsForCreate(user, fieldId);
        Collection projectBeans = this.fieldConfigSchemeBeanFactory.getProjectBeans((Collection)FieldConfigSchemeResource.checkResult(availableProjects)).stream().filter(project -> !ignoredProjectIds.contains(project.getId()) && this.queryMatchesProject(queryTerms, (ProjectBean)project)).collect(Collectors.toList());
        ServiceOutcome globalAvailable = isIntentUpdate ? this.fieldConfigSchemeService.isGlobalAvailableForUpdate(user, fieldId, configSchemeId.get().longValue()) : this.fieldConfigSchemeService.isGlobalAvailableForCreate(user, fieldId);
        AvailableProjectsBean availableProjectsBean = new AvailableProjectsBean((Boolean)FieldConfigSchemeResource.checkResult(globalAvailable), projectBeans);
        PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)maxResults);
        Page page = Pages.toPage(() -> availableProjectsBean.getProjects().iterator(), (PageRequest)pageRequest);
        PageBean<ProjectBean> bean = PageBean.from(pageRequest, page).build(project -> project);
        return new AvailableProjectsPaginatedBean(bean, availableProjectsBean.isGlobalAvailable());
    }

    private boolean queryMatchesProject(List<String> queryTerms, ProjectBean project) {
        Stream subjectTerms = Stream.concat(Arrays.asList(project.getName().toLowerCase().split("\\s")).stream(), Arrays.asList(project.getKey().toLowerCase().split("\\s")).stream());
        return queryTerms.stream().allMatch(queryTerm -> subjectTerms.anyMatch(subjectTerm -> subjectTerm.contains((CharSequence)queryTerm)));
    }

    static class AvailableProjectsPaginatedBean {
        @XmlElement
        private final boolean globalAvailable;
        @XmlElement
        private final PageBean<ProjectBean> results;

        public AvailableProjectsPaginatedBean(PageBean<ProjectBean> results, boolean isGlobalAvailable) {
            this.globalAvailable = isGlobalAvailable;
            this.results = results;
        }

        public PageBean<ProjectBean> getResults() {
            return this.results;
        }
    }
}

