/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.index;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.internal.v2.index.ReindexStatusBean;
import com.atlassian.jira.rest.v2.index.TaskDescriptorHelper;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="reindex")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ReindexInternalResource {
    private static final Logger log = LoggerFactory.getLogger(ReindexInternalResource.class);
    private final ClusterManager clusterManager;
    private final TaskManager taskManager;
    private final TaskDescriptorHelper taskDescriptorHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager permissionManager;

    @Inject
    public ReindexInternalResource(ClusterManager clusterManager, TaskManager taskManager, JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager permissionManager) {
        this.clusterManager = clusterManager;
        this.taskManager = taskManager;
        this.taskDescriptorHelper = new TaskDescriptorHelper(taskManager);
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
    }

    @DELETE
    @Path(value="unlock")
    public Response unlockReindex() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (!this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user)) {
            throw new NotAuthorisedWebException();
        }
        TaskDescriptor<IndexCommandResult> activeIndexTask = this.taskDescriptorHelper.getActiveIndexTask();
        if (activeIndexTask == null) {
            log.debug("Couldn't find running reindex task");
            return this.createResponse(Response.Status.NO_CONTENT, "Couldn't find running reindex task.");
        }
        Optional<Node> originOfTask = this.findLiveOriginOfTask(activeIndexTask);
        if (originOfTask.isPresent()) {
            String msg = "You are not supposed to cancel reindex while node '" + originOfTask.get().getNodeId() + "' is running.";
            log.warn(msg);
            return this.createResponse(Response.Status.CONFLICT, msg);
        }
        log.info("Cancelling foreground reindex task '{}' from node '{}'", (Object)activeIndexTask.getTaskId(), (Object)activeIndexTask.getNodeId());
        this.taskManager.removeTask(activeIndexTask.getTaskId());
        return this.createResponse(Response.Status.OK, "Reindex task has been removed.");
    }

    private Response createResponse(Response.Status status, String message) {
        return Response.noContent().cacheControl(CacheControl.never()).status(status).entity((Object)new ReindexStatusBean(message)).build();
    }

    private Optional<Node> findLiveOriginOfTask(TaskDescriptor<?> taskDescriptor) {
        return this.clusterManager.findLiveNodes().stream().filter(n -> Objects.equals(n.getNodeId(), taskDescriptor.getNodeId())).findFirst();
    }
}

