/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.issue;

import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.rest.api.field.FieldBean;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="field")
@Produces(value={"application/json"})
public class FieldResource {
    private final FieldManager fieldManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final FieldScreenManager fieldScreenManager;
    private final SearchHandlerManager searchHandlerManager;

    @Inject
    public FieldResource(FieldManager fieldManager, FieldConfigSchemeManager fieldConfigSchemeManager, FieldScreenManager fieldScreenManager, SearchHandlerManager searchHandlerManager) {
        this.fieldManager = fieldManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.fieldScreenManager = fieldScreenManager;
        this.searchHandlerManager = searchHandlerManager;
    }

    @GET
    @Path(value="{fieldId}")
    public Response getField(@PathParam(value="fieldId") String fieldId) {
        ConfigurableField field = this.fieldManager.getConfigurableField(fieldId);
        if (field != null) {
            return Response.ok((Object)FieldBean.shortBean((Field)field, this.fieldManager, this.searchHandlerManager)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="{fieldId}/contexts")
    public Response getContexts(@PathParam(value="fieldId") String fieldId) {
        ConfigurableField field = this.fieldManager.getConfigurableField(fieldId);
        if (field != null) {
            List beans = this.fieldConfigSchemeManager.getConfigSchemesForField(field).stream().map(x$0 -> ItemBean.fromFieldConfigScheme(x$0)).collect(Collectors.toList());
            return Response.ok(beans).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="{fieldId}/screens")
    public Response getScreens(@PathParam(value="fieldId") String fieldId) {
        if (this.fieldManager.getField(fieldId) != null) {
            List beans = this.fieldScreenManager.getFieldScreenTabs(fieldId).stream().flatMap(tab -> ItemBean.fromScreenTab(tab, fieldId)).collect(Collectors.toList());
            return Response.ok(beans).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public static class ItemBean {
        @JsonProperty
        public long id;
        @JsonProperty
        public String name;
        @JsonProperty
        public String tabName;

        private static ItemBean fromFieldConfigScheme(FieldConfigScheme configScheme) {
            ItemBean bean = new ItemBean();
            bean.id = configScheme.getId();
            bean.name = configScheme.getName();
            bean.tabName = null;
            return bean;
        }

        private static Stream<ItemBean> fromScreenTab(FieldScreenTab tab, String fieldId) {
            FieldScreen screen = tab.getFieldScreen();
            String tabName = null;
            if (screen != null) {
                for (FieldScreenTab screenTab : screen.getTabs()) {
                    if (screenTab.getFieldScreenLayoutItem(fieldId) == null) continue;
                    tabName = screenTab.getName();
                    break;
                }
                ItemBean bean = new ItemBean();
                bean.id = screen.getId();
                bean.name = screen.getName();
                bean.tabName = tabName;
                return Stream.of(bean);
            }
            return Stream.of(new ItemBean[0]);
        }
    }
}

