/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.reactions;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.reactions.CommentReactionsService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.internal.v2.reactions.AddReactionRequestBean;
import com.atlassian.jira.rest.internal.v2.reactions.GetReactionsRequestBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.Scanner;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="reactions")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ReactionsResource {
    private static final Logger log = LoggerFactory.getLogger(ReactionsResource.class);
    private final JiraAuthenticationContext authContext;
    private final CommentReactionsService commentReactionsService;
    private final WebResourceUrlProvider webResourceUrlProvider;

    @Inject
    public ReactionsResource(JiraAuthenticationContext authContext, @ComponentImport CommentReactionsService commentReactionsService, @ComponentImport WebResourceUrlProvider webResourceUrlProvider) {
        this.authContext = authContext;
        this.commentReactionsService = commentReactionsService;
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    @POST
    @Path(value="view")
    public Response getReactions(GetReactionsRequestBean request) {
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        return this.createResponse(this.commentReactionsService.getReactions(loggedInUser, request.getCommentIds()));
    }

    @GET
    public Response getDetailedReaction(@QueryParam(value="commentId") Long commentId, @QueryParam(value="emojiId") String emojiId) {
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        return this.createResponse(this.commentReactionsService.getDetailedReaction(loggedInUser, commentId, emojiId));
    }

    @POST
    public Response addReaction(AddReactionRequestBean request) {
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        if (loggedInUser == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.createResponse(this.commentReactionsService.addReaction(loggedInUser, request.getCommentId(), request.getEmojiId()));
    }

    @DELETE
    public Response deleteReaction(@QueryParam(value="commentId") Long commentId, @QueryParam(value="emojiId") String emojiId) {
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        if (loggedInUser == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.createResponse(this.commentReactionsService.deleteReaction(loggedInUser, commentId, emojiId));
    }

    @GET
    @Path(value="emojis")
    public Response listEmojis() {
        String emojiSrpiteUrl = this.webResourceUrlProvider.getStaticPluginResourceUrl("com.atlassian.jira.jira-frontend-plugin:comment-reactions-emoji", "reactions-sprite.png", UrlMode.ABSOLUTE);
        InputStream inputStream = ClassLoaderUtils.getResourceAsStream((String)"emoji-standard.json", ReactionsResource.class);
        Scanner scanner = new Scanner(inputStream).useDelimiter("\\A");
        String emojiDefinitions = scanner.next();
        String emojiDefinitionsWithPoperUrl = emojiDefinitions.replaceAll("urlPlaceholder", emojiSrpiteUrl);
        return Response.ok((Object)emojiDefinitionsWithPoperUrl).cacheControl(CacheControl.forever()).build();
    }

    private <T> Response createResponse(ServiceOutcome<T> outcome) {
        if (outcome.isValid()) {
            return Response.ok((Object)outcome.get()).cacheControl(CacheControl.never()).build();
        }
        log.debug(outcome.getErrorCollection().getErrorMessages().toString());
        return Response.status((Response.Status)this.getResponseStatusFromErrorCollection(outcome.getErrorCollection())).cacheControl(CacheControl.never()).build();
    }

    private Response.Status getResponseStatusFromErrorCollection(ErrorCollection errorCollection) {
        ErrorCollection.Reason reason = ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons());
        return Objects.isNull(reason) ? Response.Status.BAD_REQUEST : Response.Status.fromStatusCode((int)reason.getHttpStatusCode());
    }
}

