/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.retranslatekeys;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.retranslate.ReTranslateKeysService;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="retranslatekeys")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ReTranslateKeysInternalResource {
    private static final Logger log = LoggerFactory.getLogger(ReTranslateKeysInternalResource.class);
    private final ReTranslateKeysService reTranslateKeysService;
    private final ResponseFactory responseFactory;

    @Inject
    public ReTranslateKeysInternalResource(@ComponentImport ReTranslateKeysService reTranslateKeysService, ResponseFactory responseFactory) {
        this.reTranslateKeysService = reTranslateKeysService;
        this.responseFactory = responseFactory;
    }

    @GET
    @Path(value="{tableOrEntityName}/{columnOrFieldName}")
    public Response dryRunReTranslateAllKeys(@PathParam(value="tableOrEntityName") String tableOrEntityName, @PathParam(value="columnOrFieldName") String columnOrFieldName, @QueryParam(value="key") String key) {
        ServiceOutcome results = this.reTranslateKeysService.dryRunReTranslateAllKeys(tableOrEntityName, columnOrFieldName, key);
        return this.respond((ServiceOutcome<List<Pair<String, String>>>)results);
    }

    @POST
    @Path(value="{tableOrEntityName}/{columnOrFieldName}")
    public Response reTranslateAllKeys(@PathParam(value="tableOrEntityName") String tableOrEntityName, @PathParam(value="columnOrFieldName") String columnOrFieldName, @QueryParam(value="key") String key) {
        ServiceOutcome results = this.reTranslateKeysService.reTranslateAllKeys(tableOrEntityName, columnOrFieldName, key);
        return this.respond((ServiceOutcome<List<Pair<String, String>>>)results);
    }

    private Response respond(ServiceOutcome<List<Pair<String, String>>> results) {
        if (!results.isValid()) {
            return this.responseFactory.errorResponse(results.getErrorCollection());
        }
        List beans = (List)((List)results.get()).stream().map(p -> new BeforeAfterBean((String)p.first(), (String)p.second())).collect(CollectorsUtil.toImmutableList());
        return this.responseFactory.okNoCache(beans);
    }

    public static class BeforeAfterBean {
        @JsonProperty
        private String original;
        @JsonProperty
        private String translation;

        public BeforeAfterBean(String original, String translation) {
            this.original = original;
            this.translation = translation;
        }

        public BeforeAfterBean() {
        }

        public String getOriginal() {
            return this.original;
        }

        public String getTranslation() {
            return this.translation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeforeAfterBean that = (BeforeAfterBean)o;
            return Objects.equals(this.original, that.original) && Objects.equals(this.translation, that.translation);
        }

        public int hashCode() {
            return Objects.hash(this.original, this.translation);
        }
    }
}

