/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.rest.util.ServiceOutcomes;
import com.atlassian.jira.util.Function;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class IssueTypeConverter
implements Function<IssueTypeJsonBean, ServiceOutcome<IssueType>> {
    private final IssueTypeManager issueTypeManager;

    public IssueTypeConverter(IssueTypeManager issueTypeManager) {
        this.issueTypeManager = issueTypeManager;
    }

    public ServiceOutcome<List<IssueType>> all(Collection<IssueTypeJsonBean> beans) {
        return ServiceOutcomes.combine(beans.stream().map(this).collect(Collectors.toList()));
    }

    public ServiceOutcome<IssueType> apply(IssueTypeJsonBean input) {
        if (StringUtils.isNotBlank((CharSequence)input.getId())) {
            return this.byId(input.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)input.getName())) {
            return this.byName(input.getName());
        }
        return ServiceOutcomeImpl.error((String)"Could not find issuetype");
    }

    private ServiceOutcome<IssueType> byId(String id) {
        return (ServiceOutcome)Optional.ofNullable(this.issueTypeManager.getIssueType(id)).map(ServiceOutcomeImpl::ok).orElse(ServiceOutcomeImpl.error((String)("Could not find issuetype by id: " + id)));
    }

    private ServiceOutcome<IssueType> byName(String name) {
        return (ServiceOutcome)this.issueTypeManager.getIssueTypes().stream().filter(issueType -> name.equals(issueType.getName())).map(ServiceOutcomeImpl::ok).findFirst().orElse(ServiceOutcomeImpl.error((String)("Could not find issuetype by name: " + name)));
    }
}

