/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import io.atlassian.fugue.Either;
import java.net.URI;
import java.util.Collection;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ResponseFactoryImpl
implements ResponseFactory {
    private final I18nHelper i18nBean;

    @Autowired
    public ResponseFactoryImpl(I18nHelper i18nBean) {
        this.i18nBean = i18nBean;
    }

    @Override
    public Response notLoggedInResponse() {
        return this.errorResponse(ErrorCollections.create((String)this.i18nBean.getText("rest.authentication.no.user.logged.in"), (ErrorCollection.Reason)ErrorCollection.Reason.NOT_LOGGED_IN));
    }

    @Override
    public Response errorResponse(com.atlassian.jira.util.ErrorCollection errorCollection) {
        ErrorCollection restErrorCollection = ErrorCollection.of(errorCollection);
        return Response.status((int)restErrorCollection.getStatus()).entity((Object)restErrorCollection).cacheControl(CacheControl.never()).build();
    }

    @Override
    public Response okNoCache(Object entity) {
        return Response.ok((Object)entity).cacheControl(CacheControl.never()).build();
    }

    @Override
    public Response created(URI self, Object entity) {
        return Response.created((URI)self).entity(entity).cacheControl(CacheControl.never()).build();
    }

    @Override
    public Response noContent() {
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    @Override
    public Response badRequest(String i18nKey, String ... args) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(this.i18nBean.getText(i18nKey, (Object)args))).cacheControl(CacheControl.never()).build();
    }

    @Override
    public Response forbidden(String i18nKey, String ... args) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of(this.i18nBean.getText(i18nKey, (Object)args))).cacheControl(CacheControl.never()).build();
    }

    @Override
    public Response notFound(String i18nKey, String ... args) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18nBean.getText(i18nKey, (Object)args))).cacheControl(CacheControl.never()).build();
    }

    @Override
    public Response generateFieldErrorResponse(com.atlassian.jira.util.ErrorCollection errors) {
        ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)errors.getReasons());
        int errorCode = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        if (worstReason != null) {
            errorCode = worstReason.getHttpStatusCode();
        }
        return Response.status((int)errorCode).entity((Object)errors.getErrors()).build();
    }

    @Override
    public Response generateErrorResponse(com.atlassian.jira.util.ErrorCollection errors) {
        ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)errors.getReasons());
        int errorCode = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        if (worstReason != null) {
            errorCode = worstReason.getHttpStatusCode();
        }
        return Response.status((int)errorCode).entity((Object)errors.getErrorMessages()).build();
    }

    @Override
    public <T> Either<Response, T> validateOutcome(ServiceOutcome<T> outcome) {
        if (outcome.isValid()) {
            return Either.right((Object)outcome.get());
        }
        return Either.left((Object)this.errorResponse(outcome.getErrorCollection()));
    }

    @Override
    public Response serviceResultToNoContentResponse(ServiceResult serviceResult) {
        if (serviceResult.isValid()) {
            return this.noContent();
        }
        return this.errorResponse(serviceResult.getErrorCollection());
    }

    @Override
    public <T> Either<Response, T> toResponse(Either<com.atlassian.jira.util.ErrorCollection, T> either) {
        return either.leftMap((Function)new Function<com.atlassian.jira.util.ErrorCollection, Response>(){

            @Override
            public Response apply(com.atlassian.jira.util.ErrorCollection errorCollection) {
                return ResponseFactoryImpl.this.errorResponse(errorCollection);
            }
        });
    }
}

