/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.keyboardshortcuts;

import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcut;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.plugin.webfragment.DefaultWebFragmentContext;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.plugins.rest.api.security.annotation.CorsAllowed;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="shortcuts")
@UnrestrictedAccess
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
@Produces(value={"application/json", "application/xml"})
@CorsAllowed
public class KeyboardShortcutResource {
    private final KeyboardShortcutManager keyboardShortcutManager;

    @Inject
    public KeyboardShortcutResource(KeyboardShortcutManager keyboardShortcutManager) {
        this.keyboardShortcutManager = keyboardShortcutManager;
    }

    @GET
    @Path(value="{buildnumber}/{hashcode}/shortcuts")
    @Produces(value={"application/json"})
    public Response getShortCuts(@QueryParam(value="context") Set<String> contextNames) {
        List<KeyboardShortcut> sortedShortcuts = this.getKeyboardShortcutsFor(contextNames);
        return Response.ok((Object)new Shortcuts(sortedShortcuts)).cacheControl(CacheControl.CACHE_FOREVER).build();
    }

    protected List<KeyboardShortcut> getKeyboardShortcutsFor(Set<String> contextNames) {
        Set<KeyboardShortcutManager.Context> contexts = this.retrieveSelectedContexts(contextNames);
        List<KeyboardShortcut> activeShortcutsUniquePerContext = this.getActiveShortcutsUniquePerContext();
        List<KeyboardShortcut> result = this.filterShortcutsBySelectedContexts(activeShortcutsUniquePerContext, contexts);
        return result;
    }

    @Nonnull
    private Set<KeyboardShortcutManager.Context> retrieveSelectedContexts(@Nullable Set<String> contextNames) {
        EnumSet<KeyboardShortcutManager.Context> contexts = EnumSet.of(KeyboardShortcutManager.Context.global);
        if (contextNames != null) {
            for (String name : contextNames) {
                KeyboardShortcutManager.Context context = KeyboardShortcutManager.Context.fromString((String)name);
                if (context == null) continue;
                contexts.add(context);
            }
        }
        return contexts;
    }

    @Nonnull
    private List<KeyboardShortcut> getActiveShortcutsUniquePerContext() {
        Map context = DefaultWebFragmentContext.get();
        return this.keyboardShortcutManager.listActiveShortcutsUniquePerContext(context);
    }

    @Nonnull
    private List<KeyboardShortcut> filterShortcutsBySelectedContexts(@Nonnull List<KeyboardShortcut> activeShortcutsUniquePerContext, @Nonnull Set<KeyboardShortcutManager.Context> contexts) {
        HashMap<Set, KeyboardShortcut> ret = new HashMap<Set, KeyboardShortcut>();
        for (KeyboardShortcut shortcut : activeShortcutsUniquePerContext) {
            if (!contexts.contains(shortcut.getContext())) continue;
            ret.put(shortcut.getShortcuts(), shortcut);
        }
        ArrayList<KeyboardShortcut> sortedShortcuts = new ArrayList<KeyboardShortcut>(ret.values());
        Collections.sort(sortedShortcuts);
        return sortedShortcuts;
    }

    @XmlRootElement
    public static class Shortcut {
        @XmlElement
        private String moduleKey;
        @XmlElement
        private Set<List<String>> keys;
        @XmlElement
        private String context;
        @XmlElement
        private String op;
        @XmlElement
        private String param;

        private Shortcut() {
        }

        public Shortcut(KeyboardShortcut shortcut) {
            this.moduleKey = shortcut.getModuleKey();
            this.keys = new LinkedHashSet<List<String>>(shortcut.getShortcuts());
            this.context = shortcut.getContext().toString();
            this.op = shortcut.getOperation().toString();
            this.param = shortcut.getParameter();
        }
    }

    @XmlRootElement
    public static class Shortcuts {
        @XmlElement
        final List<Shortcut> shortcuts = new ArrayList<Shortcut>();

        private Shortcuts() {
        }

        public Shortcuts(Collection<KeyboardShortcut> origShortcuts) {
            for (KeyboardShortcut origShortcut : origShortcuts) {
                this.shortcuts.add(new Shortcut(origShortcut));
            }
        }
    }
}

