/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.model.errors;

import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XmlRootElement
@Deprecated
public class ErrorCollection {
    @XmlElement
    private Collection<String> errorMessages = new ArrayList<String>();
    @XmlElement
    private Collection<ValidationError> errors = new ArrayList<ValidationError>();

    private ErrorCollection() {
    }

    private ErrorCollection(Collection<ValidationError> errors, Collection<String> errorMessages) {
        Assertions.notNull((String)"errors", errors);
        Assertions.notNull((String)"errorMessages", errorMessages);
        this.errorMessages.addAll(errorMessages);
        this.errors.addAll(errors);
    }

    private void addErrorCollection(com.atlassian.jira.util.ErrorCollection errorCollection) {
        Assertions.notNull((String)"errorCollection", (Object)errorCollection);
        this.errorMessages.addAll(errorCollection.getErrorMessages());
        Iterator iterator = errorCollection.getErrors().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry errorEntry = o = iterator.next();
            this.errors.add(new ValidationError((String)errorEntry.getKey(), (String)errorEntry.getValue()));
        }
    }

    private void addErrorMessage(String errorMessage) {
        this.errorMessages.add(errorMessage);
    }

    private void addValidationError(ValidationError validationError) {
        this.errors.add(validationError);
    }

    public boolean hasAnyErrors() {
        return !this.errorMessages.isEmpty() || !this.errors.isEmpty();
    }

    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    public Collection<ValidationError> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class Builder {
        private ErrorCollection errorCollection;

        public static Builder newBuilder() {
            return new Builder(Collections.emptyList(), Collections.emptyList());
        }

        public static Builder newBuilder(ValidationError ... errors) {
            Assertions.notNull((String)"errors", (Object)errors);
            return new Builder(Arrays.asList(errors), Collections.emptyList());
        }

        public static Builder newBuilder(Set<String> errorMessages) {
            Assertions.notNull((String)"errorMessages", errorMessages);
            return new Builder(Collections.emptyList(), errorMessages);
        }

        public static Builder newBuilder(Collection<ValidationError> errors) {
            Assertions.notNull((String)"errors", errors);
            return new Builder(errors, Collections.emptyList());
        }

        public static Builder newBuilder(ErrorCollection errorCollection) {
            Assertions.notNull((String)"errorCollection", (Object)errorCollection);
            return new Builder(errorCollection.getErrors(), errorCollection.getErrorMessages());
        }

        Builder(Collection<ValidationError> errors, Collection<String> errorMessages) {
            this.errorCollection = new ErrorCollection(errors, errorMessages);
        }

        public Builder addErrorCollection(com.atlassian.jira.util.ErrorCollection errorCollection) {
            Assertions.notNull((String)"errorCollection", (Object)errorCollection);
            this.errorCollection.addErrorCollection(errorCollection);
            return this;
        }

        public Builder addErrorMessage(String errorMessage) {
            Assertions.notNull((String)"errorMessage", (Object)errorMessage);
            this.errorCollection.addErrorMessage(errorMessage);
            return this;
        }

        public Builder addError(String field, String errorKey, String ... params) {
            Assertions.notNull((String)"field", (Object)field);
            Assertions.notNull((String)"errorKey", (Object)errorKey);
            if (params != null && params.length > 0) {
                this.errorCollection.addValidationError(new ValidationError(field, errorKey, Arrays.asList(params)));
            } else {
                this.errorCollection.addValidationError(new ValidationError(field, errorKey));
            }
            return this;
        }

        public ErrorCollection build() {
            return this.errorCollection;
        }
    }
}

