/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.session.cluster.SessionInvalidationReplicatedEvent;
import com.atlassian.jira.web.session.currentusers.UserSessionInvalidatedEvent;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.atlassian.fugue.Either;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="user/session")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UserSessionResource {
    private final EventPublisher eventPublisher;
    private final UserManager userManager;
    private final JiraAuthenticationContext authContext;
    private final GlobalPermissionManager permissionManager;

    @Inject
    public UserSessionResource(EventPublisher eventPublisher, UserManager userManager, JiraAuthenticationContext authContext, GlobalPermissionManager permissionManager) {
        this.eventPublisher = eventPublisher;
        this.userManager = userManager;
        this.authContext = authContext;
        this.permissionManager = permissionManager;
    }

    @DELETE
    @Path(value="{username}")
    @WebSudoRequired
    public Response deleteSession(@PathParam(value="username") String username) {
        Either<Response.Status, ApplicationUser> result = this.prechecks(username);
        result.forEach(user -> {
            this.eventPublisher.publish((Object)new SessionInvalidationReplicatedEvent(user.getUsername()));
            this.eventPublisher.publish((Object)new UserSessionInvalidatedEvent());
        });
        Response.Status resultCode = (Response.Status)result.fold(status -> status, user -> Response.Status.OK);
        return Response.status((Response.Status)resultCode).cacheControl(CacheControl.never()).build();
    }

    private Either<Response.Status, ApplicationUser> prechecks(String username) {
        boolean isAdmin;
        ApplicationUser caller = this.authContext.getLoggedInUser();
        if (caller == null) {
            return Either.left((Object)Response.Status.UNAUTHORIZED);
        }
        boolean bl = isAdmin = this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, caller) || this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, caller);
        if (!isAdmin) {
            return Either.left((Object)Response.Status.FORBIDDEN);
        }
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            return Either.left((Object)Response.Status.NOT_FOUND);
        }
        return Either.right((Object)user);
    }
}

