/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.applicationrole;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.rest.v2.admin.applicationrole.ApplicationRoleHasher;
import com.google.common.base.Charsets;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ApplicationRoleHasherImpl
implements ApplicationRoleHasher {
    private final Funnel<ApplicationRole> applicationRoleFunnel = (Funnel & Serializable)(appRole, primitiveSink) -> {
        primitiveSink.putString((CharSequence)appRole.getKey().toString(), Charsets.UTF_8);
        primitiveSink.putBoolean(appRole.isSelectedByDefault());
        for (Group group : appRole.getGroups()) {
            primitiveSink.putString((CharSequence)group.getName(), Charsets.UTF_8);
        }
        for (Group defaultGroup : appRole.getDefaultGroups()) {
            primitiveSink.putString((CharSequence)defaultGroup.getName(), Charsets.UTF_8);
        }
    };
    protected static Comparator<ApplicationRole> ApplicationRoleNameSorter = (o1, o2) -> o1.getKey().toString().compareTo(o2.getKey().toString());

    @Override
    @Nonnull
    public String getVersionHash(@Nonnull Collection<ApplicationRole> applicationRoles) {
        return this.calculateVersionHash(applicationRoles);
    }

    private String calculateVersionHash(Collection<ApplicationRole> applicationRoles) {
        HashFunction hf = Hashing.md5();
        ArrayList<ApplicationRole> appRoles = new ArrayList<ApplicationRole>(applicationRoles);
        Collections.sort(appRoles, ApplicationRoleNameSorter);
        List hashCodes = appRoles.stream().map(appRole -> hf.newHasher().putObject(appRole, this.applicationRoleFunnel).hash()).collect(Collectors.toList());
        if (hashCodes.isEmpty()) {
            return "0";
        }
        return Hashing.combineOrdered(hashCodes).toString();
    }
}

