/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.auditing;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditRecord;
import com.atlassian.jira.auditing.AuditingFilter;
import com.atlassian.jira.auditing.AuditingService;
import com.atlassian.jira.auditing.Records;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.admin.auditing.AssociatedItemBean;
import com.atlassian.jira.rest.v2.admin.auditing.AuditRecordBean;
import com.atlassian.jira.rest.v2.admin.auditing.AuditingResponseBean;
import com.atlassian.jira.rest.v2.admin.auditing.ChangedValueBean;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="auditing/")
public class AuditingResource {
    private static final int REST_RECORD_LIMIT = 1000;
    public static final String JIRA_REST_PLUGIN_KEY = "com.atlassian.jira.rest";
    private final I18nHelper i18nHelper;
    private final AuditingService auditingService;

    @Inject
    public AuditingResource(I18nHelper i18nHelper, AuditingService auditingService) {
        this.i18nHelper = i18nHelper;
        this.auditingService = auditingService;
    }

    @Deprecated
    @GET
    @Path(value="record")
    public Response getRecords(@QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @QueryParam(value="filter") String filter, @QueryParam(value="from") DateTime from, @QueryParam(value="to") DateTime to, @QueryParam(value="projectIds") String projectIds, @QueryParam(value="userIds") String userIds) {
        Integer recordsLimit = limit != null && limit > 0 && limit < 1000 ? limit : 1000;
        Long fromAsTimestamp = from == null ? null : Long.valueOf(from.toInstant().getMillis());
        Long toAsTimestamp = to == null ? null : Long.valueOf(to.toInstant().getMillis());
        ImmutableList projectIdsLong = projectIds == null ? ImmutableList.of() : this.toListLong(projectIds);
        ImmutableList userIdsString = userIds == null ? ImmutableList.of() : this.toListString(userIds);
        ServiceOutcome outcome = this.auditingService.getRecords(offset, recordsLimit, AuditingFilter.builder().filter(filter).fromTimestamp(fromAsTimestamp).toTimestamp(toAsTimestamp).projectIds((List)projectIdsLong).userIds((List)userIdsString).build());
        if (!outcome.isValid()) {
            if (outcome.getErrorCollection().getReasons().contains(ErrorCollection.Reason.FORBIDDEN)) {
                throw new NotAuthorisedWebException(ErrorCollection.of(outcome.getErrorCollection()));
            }
            if (outcome.getErrorCollection().getReasons().contains(ErrorCollection.Reason.VALIDATION_FAILED)) {
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)ErrorCollection.of(outcome.getErrorCollection())).cacheControl(CacheControl.never()).build();
            }
            if (outcome.getErrorCollection().hasAnyErrors()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(outcome.getErrorCollection())).cacheControl(CacheControl.never()).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
        }
        Records records = (Records)outcome.get();
        ImmutableList results = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)records.getResults(), (Function)new Function<AuditRecord, AuditRecordBean>(){

            public AuditRecordBean apply(AuditRecord auditRecord) {
                return new AuditRecordBean(auditRecord, AuditingResource.this.i18nHelper.getText(auditRecord.getCategory().getNameI18nKey()));
            }
        }));
        Integer responseOffset = offset != null ? offset : 0;
        Integer responseLimit = limit != null ? limit : 1000;
        AuditingResponseBean auditingResponseBean = new AuditingResponseBean((Collection<AuditRecordBean>)results, responseOffset, responseLimit, this.auditingService.getTotalNumberOfRecords());
        return Response.ok((Object)auditingResponseBean).cacheControl(CacheControl.never()).build();
    }

    private List<Long> toListLong(String idList) {
        if (idList == null) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> res = new ArrayList<Long>();
        for (String id : idList.split(",")) {
            res.add(Long.parseLong(id));
        }
        return res;
    }

    private List<String> toListString(String idList) {
        if (idList == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String id : idList.split(",")) {
            res.add(String.valueOf(id));
        }
        return res;
    }

    @Deprecated
    @POST
    @Path(value="record")
    public Response addRecord(AuditRecordBean bean, @Context HttpServletRequest request) {
        com.atlassian.jira.util.ErrorCollection outcome;
        String description;
        ArrayList associatedItems;
        ArrayList values;
        AssociatedItem objectItem;
        try {
            objectItem = bean.getObjectItem() != null ? bean.getObjectItem().toAssociatedItem() : null;
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)ErrorCollection.of("Error parsing objectItem: " + e.getMessage())).cacheControl(CacheControl.never()).build();
        }
        try {
            values = bean.getChangedValues() != null ? Lists.newArrayList((Iterable)Iterables.transform(bean.getChangedValues(), ChangedValueBean.mapToChangedValue())) : null;
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)ErrorCollection.of("Error parsing changedValues: " + e.getMessage())).cacheControl(CacheControl.never()).build();
        }
        try {
            associatedItems = bean.getAssociatedItems() != null ? Lists.newArrayList((Iterable)Iterables.transform(bean.getAssociatedItems(), AssociatedItemBean.mapToAssociatedItem())) : null;
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)ErrorCollection.of("Error parsing associatedItems: " + e.getMessage())).cacheControl(CacheControl.never()).build();
        }
        try {
            description = bean.getDescription();
        }
        catch (Exception e) {
            description = null;
        }
        String eventSourceName = this.getEventSourceNameFromRequest(request);
        com.atlassian.jira.util.ErrorCollection errorCollection = outcome = StringUtils.isEmpty((CharSequence)eventSourceName) ? this.auditingService.storeRecord(bean.getCategory(), bean.getSummary(), objectItem, (Iterable)values, (Iterable)associatedItems, description) : this.auditingService.storeRecord(bean.getCategory(), bean.getSummary(), eventSourceName, objectItem, (Iterable)values, (Iterable)associatedItems, description);
        if (outcome.getReasons().contains(ErrorCollection.Reason.FORBIDDEN)) {
            throw new NotAuthorisedWebException(ErrorCollection.of(outcome));
        }
        if (outcome.getReasons().contains(ErrorCollection.Reason.VALIDATION_FAILED)) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)ErrorCollection.of(outcome)).cacheControl(CacheControl.never()).build();
        }
        if (outcome.hasAnyErrors()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(outcome)).cacheControl(CacheControl.never()).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).cacheControl(CacheControl.never()).build();
    }

    private String getEventSourceNameFromRequest(HttpServletRequest request) {
        Object attribute = request.getAttribute("Plugin-Key");
        if (attribute == null) {
            return JIRA_REST_PLUGIN_KEY;
        }
        String eventSource = (String)attribute;
        return (String)StringUtils.defaultIfBlank((CharSequence)eventSource, (CharSequence)JIRA_REST_PLUGIN_KEY);
    }
}

