/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.permissionscheme;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.PermissionHolderType;
import com.atlassian.jira.rest.api.field.FieldBean;
import com.atlassian.jira.rest.api.permission.PermissionGrantBeanExpander;
import com.atlassian.jira.rest.api.permission.PermissionHolderBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeExpandParam;
import com.atlassian.jira.rest.api.project.ProjectRoleBean;
import com.atlassian.jira.rest.api.util.ExpandParameterParser;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public final class PermissionGrantBeanExpanderImpl
extends ExpandParameterParser<PermissionSchemeExpandParam>
implements PermissionGrantBeanExpander {
    private static final Splitter SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private final Map<JiraPermissionHolderType, Expander> expanders;

    @Autowired
    public PermissionGrantBeanExpanderImpl(final JiraAuthenticationContext authenticationContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n, final UserBeanFactory userBeanFactory, final UserManager userManager, final ProjectRoleBeanFactory projectRoleBeanFactory, final GroupManager groupManager, final ProjectRoleManager projectRoleManager, final CustomFieldManager customFieldManager, final FieldManager fieldManager, final SearchHandlerManager searchHandlerManager) {
        super(i18n, PermissionSchemeExpandParam.class);
        final GroupJsonBeanBuilder groupJsonBeanBuilder = new GroupJsonBeanBuilder(jiraBaseUrls);
        Expander customFieldExpander = new Expander(){

            @Override
            public PermissionHolderBean.Builder expand(String parameter, PermissionHolderBean.Builder holderBean) {
                CustomField customField = customFieldManager.getCustomFieldObject(parameter);
                FieldBean customFieldBean = FieldBean.shortBean((Field)customField, fieldManager, searchHandlerManager);
                return holderBean.setField(customFieldBean);
            }
        };
        this.expanders = ImmutableMap.of((Object)JiraPermissionHolderType.USER, (Object)new Expander(){

            @Override
            public PermissionHolderBean.Builder expand(String parameter, PermissionHolderBean.Builder holderBean) {
                ApplicationUser user = userManager.getUserByKey(parameter);
                UserJsonBean userBean = userBeanFactory.createBean(user, authenticationContext.getUser());
                return holderBean.setUser(userBean);
            }
        }, (Object)JiraPermissionHolderType.PROJECT_ROLE, (Object)new Expander(){

            @Override
            public PermissionHolderBean.Builder expand(String parameter, PermissionHolderBean.Builder holderBean) {
                ProjectRole projectRole = projectRoleManager.getProjectRole(Long.valueOf(parameter));
                ProjectRoleBean projectRoleBean = projectRoleBeanFactory.shortProjectRole(projectRole);
                return holderBean.setProjectRole(projectRoleBean);
            }
        }, (Object)JiraPermissionHolderType.GROUP, (Object)new Expander(){

            @Override
            public PermissionHolderBean.Builder expand(String parameter, PermissionHolderBean.Builder holderBean) {
                Group group = groupManager.getGroup(parameter);
                GroupJsonBean groupJsonBean = groupJsonBeanBuilder.group(group).build();
                return holderBean.setGroup(groupJsonBean);
            }
        }, (Object)JiraPermissionHolderType.GROUP_CUSTOM_FIELD, (Object)customFieldExpander, (Object)JiraPermissionHolderType.USER_CUSTOM_FIELD, (Object)customFieldExpander);
    }

    @Override
    public PermissionHolderBean expand(PermissionHolderBean grantBean, PermissionHolderType holderType, List<PermissionSchemeExpandParam> expands) {
        Option<Expander> expander;
        Option jiraHolderType = JiraPermissionHolderType.fromKey((String)holderType.getKey(), (String)grantBean.getParameter());
        if (jiraHolderType.isDefined() && (expander = this.getExpander((JiraPermissionHolderType)jiraHolderType.get(), expands)).isDefined()) {
            return ((Expander)expander.get()).expand(grantBean.getParameter(), PermissionHolderBean.builder(grantBean)).build();
        }
        return grantBean;
    }

    private Option<Expander> getExpander(JiraPermissionHolderType permissionHolderType, List<PermissionSchemeExpandParam> expands) {
        for (PermissionSchemeExpandParam expand : expands) {
            if (!expand.expandsType((PermissionHolderType)permissionHolderType) || !this.expanders.containsKey(permissionHolderType)) continue;
            return Option.some((Object)this.expanders.get(permissionHolderType));
        }
        return Option.none();
    }

    private static interface Expander {
        public PermissionHolderBean.Builder expand(String var1, PermissionHolderBean.Builder var2);
    }
}

