/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.avatar;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImageDataProvider;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarPickerHelperImpl;
import com.atlassian.jira.avatar.CroppingAvatarImageDataProviderFactory;
import com.atlassian.jira.avatar.Selection;
import com.atlassian.jira.avatar.TemporaryAvatar;
import com.atlassian.jira.avatar.TemporaryAvatars;
import com.atlassian.jira.icon.IconOwningObjectId;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.util.AttachmentHelper;
import com.atlassian.jira.rest.v2.avatar.TemporaryAvatarUploader;
import com.atlassian.jira.rest.v2.avatar.UploadedAvatar;
import com.atlassian.jira.rest.v2.avatar.ValidationException;
import com.atlassian.jira.rest.v2.issue.AvatarBean;
import com.atlassian.jira.rest.v2.issue.AvatarBeanFactory;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TemporaryAvatarHelper {
    private static Logger logger = LoggerFactory.getLogger(TemporaryAvatarHelper.class);
    private final TemporaryAvatarUploader avatarUploader;
    private final AttachmentHelper attachmentHelper;
    private final I18nHelper i18nHelper;
    private final CroppingAvatarImageDataProviderFactory croppingAvatarImageDataProviderFactory;
    private final VelocityRequestContextFactory requestContextFactory;
    private final TemporaryAvatars temporaryAvatars;
    private final AvatarManager avatarManager;
    private final JiraContactHelper jiraContactHelper;

    @Inject
    public TemporaryAvatarHelper(TemporaryAvatarUploader avatarUploader, AttachmentHelper attachmentHelper, TemporaryAvatars temporaryAvatars, VelocityRequestContextFactory requestContextFactory, CroppingAvatarImageDataProviderFactory croppingAvatarImageDataProviderFactory, I18nHelper i18nHelper, @ComponentImport AvatarManager avatarManager, @ComponentImport JiraContactHelper jiraContactHelper) {
        this.avatarUploader = Objects.requireNonNull(avatarUploader);
        this.attachmentHelper = Objects.requireNonNull(attachmentHelper);
        this.temporaryAvatars = Objects.requireNonNull(temporaryAvatars);
        this.requestContextFactory = Objects.requireNonNull(requestContextFactory);
        this.croppingAvatarImageDataProviderFactory = Objects.requireNonNull(croppingAvatarImageDataProviderFactory);
        this.i18nHelper = Objects.requireNonNull(i18nHelper);
        this.avatarManager = Objects.requireNonNull(avatarManager);
        this.jiraContactHelper = Objects.requireNonNull(jiraContactHelper);
    }

    public Response storeTemporaryAvatar(ApplicationUser remoteUser, IconType iconType, String ownerId, Avatar.Size targetSize, String filename, Long size, HttpServletRequest request) {
        AttachmentHelper.ValidationResult validationResult = this.attachmentHelper.validate(request, filename, size);
        if (!validationResult.isValid()) {
            this.throwWebException(validationResult.getErrorMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        try {
            UploadedAvatar uploadedAvatar = this.avatarUploader.createUploadedAvatarFromStream(validationResult.getInputStream(), filename, validationResult.getContentType(), validationResult.getSize());
            TemporaryAvatar temporaryAvatar = new TemporaryAvatar(validationResult.getContentType(), uploadedAvatar.getContentType(), filename, uploadedAvatar.getImageFile(), null);
            this.temporaryAvatars.storeTemporaryAvatar(remoteUser, temporaryAvatar, iconType, new IconOwningObjectId(ownerId));
            AvatarPickerHelperImpl.TemporaryAvatarBean temporaryAvatarBean = new AvatarPickerHelperImpl.TemporaryAvatarBean(this.getTemporaryAvatarUrl(), uploadedAvatar.getWidth(), uploadedAvatar.getHeight(), this.isCroppingNeeded(uploadedAvatar, targetSize));
            AvatarCroppingBean croppingInstructions = AvatarBeanFactory.createTemporaryAvatarCroppingInstructions(temporaryAvatarBean);
            if (temporaryAvatarBean.isCroppingNeeded()) {
                return Response.status((Response.Status)Response.Status.CREATED).entity((Object)croppingInstructions).cacheControl(CacheControl.never()).build();
            }
            AvatarBean avatarBean = this.createAvatarFromTemporary(remoteUser, iconType, ownerId, croppingInstructions);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)avatarBean).cacheControl(CacheControl.never()).build();
        }
        catch (ValidationException e) {
            this.throwWebException(e.getMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        catch (IOException e) {
            this.throwWebException(e.getMessage(), ErrorCollection.Reason.SERVER_ERROR);
        }
        catch (IllegalAccessException e) {
            this.throwWebException(null, ErrorCollection.Reason.FORBIDDEN);
        }
        throw new AssertionError((Object)"unreachable!");
    }

    public Response storeTemporaryAvatar(ApplicationUser remoteUser, IconType iconType, String ownerId, Avatar.Size targetSize, FilePart filePart, HttpServletRequest request) {
        String fullPath = filePart.getName();
        String filename = fullPath.substring(fullPath.lastIndexOf("\\") + 1, fullPath.length());
        AttachmentHelper.ValidationResult validationResult = this.attachmentHelper.validate(request, filename, null);
        if (!validationResult.isValid()) {
            this.throwWebException(validationResult.getErrorMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        try {
            UploadedAvatar uploadedAvatar = this.avatarUploader.createUploadedAvatarFromStream(filePart.getInputStream(), filename, filePart.getContentType());
            TemporaryAvatar temporaryAvatar = new TemporaryAvatar(validationResult.getContentType(), uploadedAvatar.getContentType(), filename, uploadedAvatar.getImageFile(), null);
            this.temporaryAvatars.storeTemporaryAvatar(remoteUser, temporaryAvatar, iconType, new IconOwningObjectId(ownerId));
            AvatarPickerHelperImpl.TemporaryAvatarBean temporaryAvatarBean = new AvatarPickerHelperImpl.TemporaryAvatarBean(this.getTemporaryAvatarUrl(), uploadedAvatar.getWidth(), uploadedAvatar.getHeight(), this.isCroppingNeeded(uploadedAvatar, targetSize));
            AvatarCroppingBean croppingInstructions = AvatarBeanFactory.createTemporaryAvatarCroppingInstructions(temporaryAvatarBean);
            if (temporaryAvatarBean.isCroppingNeeded()) {
                return Response.status((Response.Status)Response.Status.CREATED).entity((Object)("<html><body><textarea>{\"url\": \"" + temporaryAvatarBean.getUrl() + "\",\"cropperWidth\": \"" + temporaryAvatarBean.getCropperWidth() + "\",\"cropperOffsetX\": \"" + temporaryAvatarBean.getCropperOffsetX() + "\",\"cropperOffsetY\": \"" + temporaryAvatarBean.getCropperOffsetY() + "\",\"isCroppingNeeded\": \"" + temporaryAvatarBean.isCroppingNeeded() + "\"}</textarea></body></html>")).cacheControl(CacheControl.never()).build();
            }
            AvatarBean avatarBean = this.createAvatarFromTemporary(remoteUser, iconType, ownerId, croppingInstructions);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)("<html><body><textarea>{\"id\": \"" + avatarBean.getId() + "\"}</textarea></body></html>")).cacheControl(CacheControl.never()).build();
        }
        catch (ValidationException e) {
            this.throwWebException(e.getMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        catch (IOException e) {
            this.throwWebException(e.getMessage(), ErrorCollection.Reason.SERVER_ERROR);
        }
        catch (IllegalAccessException e) {
            this.throwWebException(null, ErrorCollection.Reason.FORBIDDEN);
        }
        throw new AssertionError((Object)"unreachable!");
    }

    public AvatarBean createAvatarFromTemporary(ApplicationUser remoteUser, IconType iconType, String ownerId, AvatarCroppingBean croppingInstructions) {
        Selection selection = new Selection(croppingInstructions.getCropperOffsetX(), croppingInstructions.getCropperOffsetY(), croppingInstructions.getCropperWidth(), croppingInstructions.getCropperWidth());
        Avatar conversionResult = this.convertTemporaryToReal(remoteUser, ownerId, iconType, selection);
        AvatarBean avatarBean = AvatarBeanFactory.createAvatarBean(conversionResult, remoteUser, this.avatarManager.userCanDelete(remoteUser, conversionResult));
        return avatarBean;
    }

    private boolean isCroppingNeeded(UploadedAvatar image, Avatar.Size targetSize) {
        boolean isSquare = image.getHeight() == image.getWidth();
        boolean widthWithinBounds = image.getWidth() <= targetSize.getPixels();
        return !widthWithinBounds || !isSquare;
    }

    public String getTemporaryAvatarUrl() {
        return this.getBaseUrl() + "/secure/temporaryavatar?cropped=true&magic=" + System.currentTimeMillis();
    }

    private String getBaseUrl() {
        return this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Avatar convertTemporaryToReal(ApplicationUser remoteUser, String ownerId, IconType iconType, Selection selection) {
        block8: {
            Avatar avatar;
            TemporaryAvatar temporaryAvatar = this.temporaryAvatars.getCurrentTemporaryAvatar();
            if (temporaryAvatar == null) {
                this.throwWebException(this.i18nHelper.getText("avatarpicker.upload.failure"), ErrorCollection.Reason.SERVER_ERROR);
            }
            InputStream imageDataStream = temporaryAvatar.getImageData();
            try {
                AvatarImageDataProvider imageDataProvider = this.croppingAvatarImageDataProviderFactory.createStreamsFrom(imageDataStream, selection);
                if (!this.avatarManager.userCanCreateFor(remoteUser, iconType, new IconOwningObjectId(ownerId))) {
                    throw new IllegalAccessException();
                }
                Avatar newAvatar = this.avatarManager.create(iconType, new IconOwningObjectId(ownerId), imageDataProvider);
                this.temporaryAvatars.dispose(temporaryAvatar);
                avatar = newAvatar;
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly((InputStream)imageDataStream);
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Unable to create avatar.", (Throwable)e);
                    this.throwWebException(this.i18nHelper.getText("avatarpicker.upload.temp.io", this.jiraContactHelper.getAdministratorContactMessage(this.i18nHelper)), ErrorCollection.Reason.SERVER_ERROR);
                    break block8;
                }
                catch (IllegalAccessException e) {
                    logger.error("Unable to create avatar.", (Throwable)e);
                    this.throwWebException(this.i18nHelper.getText("avatarpicker.upload.temp.io", this.jiraContactHelper.getAdministratorContactMessage(this.i18nHelper)), ErrorCollection.Reason.FORBIDDEN);
                }
            }
            IOUtils.closeQuietly((InputStream)imageDataStream);
            return avatar;
        }
        throw new AssertionError((Object)"ureachable");
    }

    private void throwWebException(String message, ErrorCollection.Reason reason) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(message, reason);
        this.throwWebException((com.atlassian.jira.util.ErrorCollection)errorCollection);
    }

    private void throwWebException(com.atlassian.jira.util.ErrorCollection errorCollection) {
        throw new RESTException(ErrorCollection.of(errorCollection));
    }
}

