/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.common;

import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="link")
public class SimpleLinkBean {
    @XmlElement
    private String id;
    @XmlElement
    private String styleClass;
    @XmlElement
    private String iconClass;
    @XmlElement
    private String label;
    @XmlElement
    private String title;
    @XmlElement
    private String href;
    @XmlElement
    private Integer weight;
    @XmlElement
    private Map<String, String> params;
    public static final SimpleLinkBean DOC_EXAMPLE = new SimpleLinkBean("edit-issue", "edit-cls", "Edit", "Click to Edit the Issue", "/secure/EditIssue!default.jspa?id=10000", "aui-icon aui-icon-small aui-iconfont-edit");

    public SimpleLinkBean() {
    }

    public SimpleLinkBean(SimpleLink link) {
        this(link.getId(), link.getStyleClass(), link.getLabel(), link.getTitle(), link.getUrl(), link.getParams() != null ? (String)link.getParams().get("iconClass") : null, link.getWeight());
        this.params = link.getParams();
    }

    public SimpleLinkBean(String id, String styleClass, String label, String title, String href, String iconClass) {
        this(id, styleClass, label, title, href, iconClass, null);
    }

    public SimpleLinkBean(String id, String styleClass, String label, String title, String href, String iconClass, Integer weight) {
        this.id = id;
        this.styleClass = styleClass;
        this.label = label;
        this.title = title;
        this.href = href;
        this.iconClass = iconClass;
        this.weight = weight;
    }

    public String getId() {
        return this.id;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHref() {
        return this.href;
    }

    public String getIconClass() {
        return this.iconClass;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleLinkBean that = (SimpleLinkBean)o;
        if (!this.href.equals(that.href)) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (!this.label.equals(that.label)) {
            return false;
        }
        if (this.styleClass != null ? !this.styleClass.equals(that.styleClass) : that.styleClass != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.weight != null ? !this.weight.equals(that.weight) : that.weight != null) {
            return false;
        }
        return !(this.params != null ? !this.params.equals(that.params) : that.params != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.styleClass != null ? this.styleClass.hashCode() : 0);
        result = 31 * result + this.label.hashCode();
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + this.href.hashCode();
        result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SimpleLinkBean{id='" + this.id + '\'' + ", styleClass='" + this.styleClass + '\'' + ", label='" + this.label + '\'' + ", title='" + this.title + '\'' + ", href='" + this.href + '\'' + '}';
    }
}

