/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.dashboard;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.dashboard.DashboardService;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.PermissionException;
import com.atlassian.jira.bc.dashboard.DashboardItem;
import com.atlassian.jira.bc.dashboard.DashboardItemPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBeanSelfFunctions;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.function.Function;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
@Path(value="dashboard/{dashboardId}/items/{itemId}/properties")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public final class DashboardItemPropertyResource {
    private static final Logger log = LoggerFactory.getLogger(DashboardItemPropertyResource.class);
    private final BasePropertyResource<DashboardItem> delegate;
    private final DashboardService dashboardService;
    private final JiraAuthenticationContext authenticationContext;
    private final I18nHelper i18nHelper;

    @Inject
    public DashboardItemPropertyResource(DashboardItemPropertyService dashboardItemPropertyService, DashboardService dashboardService, JiraAuthenticationContext authenticationContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n, I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
        this.dashboardService = dashboardService;
        this.authenticationContext = authenticationContext;
        this.delegate = new BasePropertyResource(dashboardItemPropertyService, authenticationContext, jiraBaseUrls, i18n, EntityPropertyBeanSelfFunctions.EMPTY_BIFUNCTION, EntityPropertyType.DASHBOARD_ITEM_PROPERTY);
    }

    @GET
    public Response getPropertiesKeys(final @PathParam(value="dashboardId") String dashboardId, final @PathParam(value="itemId") String itemId) {
        return (Response)this.validateDashboardContainsItem(dashboardId, itemId).left().on((Function)new Function<String, Response>(){

            @Override
            public Response apply(String input) {
                return DashboardItemPropertyResource.this.delegate.withSelfFunction(EntityPropertyBeanSelfFunctions.dashboardItemPropertySelfBiFunction((String)dashboardId)).getPropertiesKeys(itemId);
            }
        });
    }

    @PUT
    @Path(value="/{propertyKey}")
    public Response setProperty(@PathParam(value="dashboardId") String dashboardId, final @PathParam(value="itemId") String itemId, final @PathParam(value="propertyKey") String propertyKey, final @Context HttpServletRequest request) {
        return (Response)this.validateDashboardContainsItem(dashboardId, itemId).left().on((Function)new Function<String, Response>(){

            @Override
            public Response apply(String input) {
                return DashboardItemPropertyResource.this.delegate.setProperty(itemId, propertyKey, request);
            }
        });
    }

    @GET
    @Path(value="/{propertyKey}")
    public Response getProperty(final @PathParam(value="dashboardId") String dashboardId, final @PathParam(value="itemId") String itemId, final @PathParam(value="propertyKey") String propertyKey) {
        return (Response)this.validateDashboardContainsItem(dashboardId, itemId).left().on((Function)new Function<String, Response>(){

            @Override
            public Response apply(String input) {
                return DashboardItemPropertyResource.this.delegate.withSelfFunction(EntityPropertyBeanSelfFunctions.dashboardItemPropertySelfBiFunction((String)dashboardId)).getProperty(itemId, propertyKey);
            }
        });
    }

    @DELETE
    @Path(value="/{propertyKey}")
    public Response deleteProperty(@PathParam(value="dashboardId") String dashboardId, final @PathParam(value="itemId") String itemId, final @PathParam(value="propertyKey") String propertyKey) {
        return (Response)this.validateDashboardContainsItem(dashboardId, itemId).left().on((Function)new Function<String, Response>(){

            @Override
            public Response apply(String input) {
                return DashboardItemPropertyResource.this.delegate.deleteProperty(itemId, propertyKey);
            }
        });
    }

    private Either<Response, String> validateDashboardContainsItem(String dashboardId, String itemId) {
        String userName = this.authenticationContext.getUser() != null ? this.authenticationContext.getUser().getUsername() : null;
        Either notFoundResponse = Either.left((Object)this.notFoundResponse(dashboardId, itemId));
        try {
            Option dashboardForGadget = Option.option((Object)this.dashboardService.getDashboardForGadget(GadgetId.valueOf((String)itemId), userName).getOrNull());
            if (dashboardForGadget.isEmpty() || !((DashboardState)dashboardForGadget.get()).getId().value().equals(dashboardId)) {
                return notFoundResponse;
            }
            return Either.right((Object)itemId);
        }
        catch (PermissionException ex) {
            return notFoundResponse;
        }
        catch (RuntimeException ex) {
            log.warn(String.format("unexpected exception when retrieving dashboard item %s in dashboard %s", itemId, dashboardId), (Throwable)ex);
            return notFoundResponse;
        }
    }

    private Response notFoundResponse(String dashboardId, String itemId) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18nHelper.getText("rest.dashboard.item.not.found", dashboardId, itemId))).build();
    }
}

