/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.entity;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.entity.remotelink.RemoteEntityLink;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.entity.RemoteEntityLinkJsonBean;
import com.atlassian.jira.rest.v2.entity.RemoteEntityLinksJsonBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public abstract class AbstractRemoteEntityLinkResource<S, T extends RemoteEntityLink<S>> {
    protected final I18nHelper i18n;
    protected final JiraAuthenticationContext jiraAuthenticationContext;
    protected final JsonEntityPropertyManager jsonEntityPropertyManager;
    protected final UriInfo contextUriInfo;

    protected AbstractRemoteEntityLinkResource(I18nHelper i18n, JiraAuthenticationContext jiraAuthenticationContext, JsonEntityPropertyManager jsonEntityPropertyManager, UriInfo contextUriInfo) {
        this.i18n = i18n;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.contextUriInfo = contextUriInfo;
    }

    protected RemoteEntityLinkJsonBean toBean(T link) {
        return new RemoteEntityLinkJsonBean().self(this.createSelfLink(link)).link(link.getJsonString());
    }

    protected RemoteEntityLinksJsonBean toBean(Collection<? extends T> links) {
        ArrayList<RemoteEntityLinkJsonBean> beans = new ArrayList<RemoteEntityLinkJsonBean>(links.size());
        for (RemoteEntityLink link : links) {
            beans.add(this.toBean(link));
        }
        return new RemoteEntityLinksJsonBean().links(beans);
    }

    protected Response toResponse(T link) {
        return this.toResponse(this.toBean(link));
    }

    protected Response toResponse(Collection<? extends T> links) {
        return this.toResponse(this.toBean(links));
    }

    protected Response toResponse(Object entity) {
        return Response.ok((Object)entity).cacheControl(CacheControl.never()).build();
    }

    protected Response toSuccessfulPostResponse(T link) {
        return Response.created((URI)this.createSelfLink(link)).cacheControl(CacheControl.never()).build();
    }

    protected Response toSuccessfulDeleteResponse() {
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    protected abstract URI createSelfLink(T var1);

    protected <T extends ServiceResult> T valid(T result) {
        if (!result.isValid()) {
            throw new RESTException(ErrorCollection.of(result.getErrorCollection()));
        }
        return result;
    }

    protected ApplicationUser getUser() {
        return this.jiraAuthenticationContext.getUser();
    }
}

