/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.entity.property;

import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.BiFunction;

public class EntityPropertiesKeysBean {
    @JsonProperty(value="keys")
    private final List<EntityPropertyKeyBean> entityPropertyKeyBeans;

    EntityPropertiesKeysBean(List<EntityPropertyKeyBean> entityPropertyKeyBeans) {
        this.entityPropertyKeyBeans = entityPropertyKeyBeans;
    }

    public static EntityPropertiesKeysBean build(final JiraBaseUrls urls, final Long issueId, List<String> propertyKeys, final BiFunction<Long, String, String> selfFunction) {
        return new EntityPropertiesKeysBean((List<EntityPropertyKeyBean>)ImmutableList.copyOf((Iterable)Iterables.transform(propertyKeys, (Function)new Function<String, EntityPropertyKeyBean>(){

            public EntityPropertyKeyBean apply(String propertyKey) {
                return new EntityPropertyKeyBean(propertyKey, EntityPropertyBean.propertySelf((JiraBaseUrls)urls, (Long)issueId, (String)propertyKey, (BiFunction)selfFunction));
            }
        })));
    }

    public List<EntityPropertyKeyBean> getEntityPropertyKeyBeans() {
        return this.entityPropertyKeyBeans;
    }

    public static class EntityPropertyKeyBean {
        @JsonProperty
        private final String self;
        @JsonProperty
        private final String key;

        EntityPropertyKeyBean(String key, String self) {
            this.key = (String)Preconditions.checkNotNull((Object)key);
            this.self = (String)Preconditions.checkNotNull((Object)self);
        }

        public String getSelf() {
            return this.self;
        }

        public String getKey() {
            return this.key;
        }
    }
}

