/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XmlRootElement(name="avatar")
public class AvatarBean {
    public static final AvatarBean DOC_EXAMPLE = new AvatarBean("1000", "fred", true, false, (Map<String, URI>)ImmutableMap.of((Object)"16x16", (Object)URI.create("http://localhost:8090/jira/secure/useravatar?size=xsmall&avatarId=10040"), (Object)"24x24", (Object)URI.create("http://localhost:8090/jira/secure/useravatar?size=small&avatarId=10040"), (Object)"32x32", (Object)URI.create("http://localhost:8090/jira/secure/useravatar?size=medium&avatarId=10040"), (Object)"48x48", (Object)URI.create("http://localhost:8090/jira/secure/useravatar?avatarId=10040")));
    public static final AvatarBean DOC_EXAMPLE_2 = new AvatarBean("1010", "andrew", false, true, (Map<String, URI>)ImmutableMap.of((Object)"16x16", (Object)URI.create("http://localhost:8090/jira/secure/useravatar?size=xsmall&avatarId=10080"), (Object)"24x24", (Object)URI.create("http://localhost:8090/jira/secure/useravatar?size=small&avatarId=10080"), (Object)"32x32", (Object)URI.create("http://localhost:8090/jira/secure/useravatar?size=medium&avatarId=10080"), (Object)"48x48", (Object)URI.create("http://localhost:8090/jira/secure/useravatar?avatarId=10080")));
    public static final AvatarBean DOC_EXAMPLE_3 = new AvatarBean("1000", null, false, true);
    public static final Map<String, List<AvatarBean>> DOC_EXAMPLE_LIST = new HashMap<String, List<AvatarBean>>();
    public static final Map<String, List<AvatarBean>> DOC_EXAMPLE_SYSTEM_LIST;
    @XmlElement
    private String id;
    @XmlElement
    private String owner;
    @XmlElement
    private boolean isSystemAvatar;
    @XmlElement
    private boolean isSelected;
    @XmlElement
    private boolean isDeletable;
    @XmlElement
    Map<String, URI> urls;

    public AvatarBean() {
    }

    public AvatarBean(String id, String owner) {
        this(id, owner, false, null);
    }

    public AvatarBean(String id, String owner, boolean isSystemAvatar, boolean isDeletable) {
        this(id, owner, isSystemAvatar, isDeletable, null);
    }

    public AvatarBean(String id, String owner, boolean isSystemAvatar, Map<String, URI> urls) {
        this(id, owner, isSystemAvatar, !isSystemAvatar, urls);
    }

    public AvatarBean(String id, String owner, boolean isSystemAvatar, boolean isDeletable, Map<String, URI> urls) {
        this.id = id;
        this.owner = owner;
        this.isSystemAvatar = isSystemAvatar;
        this.isDeletable = isDeletable;
        this.urls = urls;
        this.isSelected = false;
    }

    public String getId() {
        return this.id;
    }

    @JsonProperty
    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public boolean getSystemAvatar() {
        return this.isSystemAvatar;
    }

    public boolean getDeletable() {
        return this.isDeletable;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    static {
        DOC_EXAMPLE_LIST.put("system", Collections.singletonList(DOC_EXAMPLE));
        DOC_EXAMPLE_LIST.put("custom", Collections.singletonList(DOC_EXAMPLE_2));
        DOC_EXAMPLE_SYSTEM_LIST = new HashMap<String, List<AvatarBean>>();
        DOC_EXAMPLE_SYSTEM_LIST.put("system", Collections.singletonList(DOC_EXAMPLE));
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class SystemAvatars {
        private List<AvatarBean> system;
    }
}

