/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.AvatarResourceHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.AccessDisablingHelper;
import com.atlassian.jira.util.AccessDisablingHelperConfig;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="avatar")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AvatarResource {
    private final AvatarResourceHelper avatarResourceHelper;
    private final AccessDisablingHelper accessDisablingHelper;
    private final JiraAuthenticationContext authContext;
    private final EventPublisher eventPublisher;

    @Inject
    public AvatarResource(AvatarResourceHelper avatarResourceHelper, JiraAuthenticationContext authContext, EventPublisher eventPublisher, AccessDisablingHelper accessDisablingHelper) {
        this.accessDisablingHelper = accessDisablingHelper;
        this.avatarResourceHelper = avatarResourceHelper;
        this.authContext = authContext;
        this.eventPublisher = eventPublisher;
    }

    @GET
    @Path(value="{type}/system")
    public Response getAllSystemAvatars(@PathParam(value="type") String type) {
        if (!this.accessDisablingHelper.canBeAccessedByCurrentUser(AccessDisablingHelperConfig.builder().blockAnonymous(true).build())) {
            throw new NotAuthorisedWebException();
        }
        IconType iconType = IconType.of((String)type);
        return this.avatarResourceHelper.getAllSystemAvatars(iconType);
    }

    @POST
    @Consumes(value={"*/*"})
    @Path(value="{type}/temporary")
    public Response storeTemporaryAvatar(@PathParam(value="type") String type, @QueryParam(value="filename") String filename, @QueryParam(value="size") Long size, @Context HttpServletRequest request) {
        IconType iconType = IconType.of((String)type);
        return this.avatarResourceHelper.storeTemporaryAvatar(iconType, null, filename, size, request);
    }

    @POST
    @Path(value="{type}/temporaryCrop")
    public Response createAvatarFromTemporary(@PathParam(value="type") String type, AvatarCroppingBean croppingInstructions) {
        IconType iconType = IconType.of((String)type);
        return this.avatarResourceHelper.cropTemporaryAvatar(iconType, null, croppingInstructions);
    }
}

