/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarPickerHelper;
import com.atlassian.jira.avatar.AvatarPickerHelperImpl;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.Selection;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.AttachmentHelper;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.rest.v2.issue.AvatarBean;
import com.atlassian.jira.rest.v2.issue.AvatarBeanFactory;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Component
public class AvatarResourceHelper {
    private JiraAuthenticationContext authContext;
    private AvatarManager avatarManager;
    private AvatarService avatarService;
    private AvatarPickerHelper avatarPickerHelper;
    private AttachmentHelper attachmentHelper;
    private final UserManager userManager;

    @Inject
    public AvatarResourceHelper(JiraAuthenticationContext authContext, AvatarManager avatarManager, AvatarService avatarService, AvatarPickerHelper avatarPickerHelper, AttachmentHelper attachmentHelper, UserManager userManager) {
        this.authContext = authContext;
        this.avatarManager = avatarManager;
        this.avatarService = avatarService;
        this.avatarPickerHelper = avatarPickerHelper;
        this.attachmentHelper = attachmentHelper;
        this.userManager = userManager;
    }

    public Map<String, List<AvatarBean>> getAllAvatars(IconType iconType, String ownerId, Long selectedAvatarId) {
        if (selectedAvatarId == null) {
            selectedAvatarId = this.avatarManager.getDefaultAvatarId(iconType);
        }
        HashMap<String, List<AvatarBean>> avatars = new HashMap<String, List<AvatarBean>>();
        ApplicationUser avatarUser = iconType.equals((Object)IconType.USER_ICON_TYPE) ? this.userManager.getUserByKey(ownerId) : null;
        AvatarBeanFactory avatarBeanFactory = new AvatarBeanFactory(this.avatarManager);
        List allSystemAvatars = this.avatarManager.getAllSystemAvatars(iconType);
        List<AvatarBean> systemAvatarBeans = avatarBeanFactory.createAvatarBeans(allSystemAvatars, avatarUser);
        this.replaceDefaultWithGravatar(avatarUser, systemAvatarBeans);
        this.setSelectedAvatar(selectedAvatarId, systemAvatarBeans);
        avatars.put("system", systemAvatarBeans);
        List customAvatarsForOwner = this.avatarManager.getCustomAvatarsForOwner(iconType, ownerId);
        List<AvatarBean> customAvatarBeans = avatarBeanFactory.createAvatarBeans(customAvatarsForOwner, avatarUser);
        avatars.put("custom", customAvatarBeans);
        this.setSelectedAvatar(selectedAvatarId, customAvatarBeans);
        return avatars;
    }

    private void replaceDefaultWithGravatar(ApplicationUser avatarUser, List<AvatarBean> avatarList) {
        if (!this.avatarService.isGravatarEnabled()) {
            return;
        }
        Optional<AvatarBean> defaultAvatarOp = this.getDefaultAvatar(avatarList);
        if (defaultAvatarOp.isPresent()) {
            AvatarBean defaultAvatar = defaultAvatarOp.get();
            avatarList.remove(defaultAvatar);
            ImmutableMap gravatarUrls = ImmutableMap.of((Object)"16x16", this.avatarService.getGravatarAvatarURL(avatarUser, Avatar.Size.SMALL).get(), (Object)"24x24", this.avatarService.getGravatarAvatarURL(avatarUser, Avatar.Size.NORMAL).get(), (Object)"32x32", this.avatarService.getGravatarAvatarURL(avatarUser, Avatar.Size.MEDIUM).get(), (Object)"48x48", this.avatarService.getGravatarAvatarURL(avatarUser, Avatar.Size.LARGE).get());
            AvatarBean gravatarBean = new AvatarBean(defaultAvatar.getId(), defaultAvatar.getOwner(), defaultAvatar.getSystemAvatar(), (Map<String, URI>)gravatarUrls);
            avatarList.add(0, gravatarBean);
        }
    }

    private Optional<AvatarBean> getDefaultAvatar(List<AvatarBean> systemAvatarBeans) {
        IconType iconType = IconType.USER_ICON_TYPE;
        String defaultAvatarID = String.valueOf(this.avatarManager.getDefaultAvatarId(iconType));
        for (AvatarBean bean : systemAvatarBeans) {
            if (!bean.getId().equals(defaultAvatarID)) continue;
            return Optional.of(bean);
        }
        return Optional.empty();
    }

    public Response getAllSystemAvatars(IconType iconType) {
        HashMap<String, List<AvatarBean>> avatars = new HashMap<String, List<AvatarBean>>();
        AvatarBeanFactory avatarBeanFactory = new AvatarBeanFactory(this.avatarManager);
        List<AvatarBean> systemAvatarBeans = avatarBeanFactory.createAvatarBeans(this.avatarManager.getAllSystemAvatars(iconType), null);
        avatars.put("system", systemAvatarBeans);
        return Response.ok(avatars).cacheControl(CacheControl.NO_CACHE).build();
    }

    private void setSelectedAvatar(Long selectedAvatarId, List<AvatarBean> avatars) {
        if (selectedAvatarId != null) {
            for (AvatarBean avatar : avatars) {
                if (!avatar.getId().equals(selectedAvatarId.toString())) continue;
                avatar.setSelected(true);
                break;
            }
        }
    }

    public Response createAvatarFromTemporary(IconType iconType, String ownerId, AvatarCroppingBean croppingInstructions) {
        Selection selection = new Selection(croppingInstructions.getCropperOffsetX(), croppingInstructions.getCropperOffsetY(), croppingInstructions.getCropperWidth(), croppingInstructions.getCropperWidth());
        AvatarPickerHelperImpl.Result conversionResult = this.avatarPickerHelper.convertTemporaryToReal(ownerId, iconType, selection);
        if (!conversionResult.isValid()) {
            this.throwWebException(conversionResult.getErrorCollection());
        }
        ApplicationUser remoteUser = this.authContext.getLoggedInUser();
        Avatar result = (Avatar)conversionResult.getResult();
        AvatarBean avatarBean = AvatarBeanFactory.createAvatarBean(result, remoteUser, this.avatarManager.userCanDelete(remoteUser, result));
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)avatarBean).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
    }

    public Response storeTemporaryAvatar(IconType iconType, String ownerId, String filename, Long size, HttpServletRequest request) {
        AvatarPickerHelperImpl.Result tempAvatarResult;
        AttachmentHelper.ValidationResult validationResult = this.attachmentHelper.validate(request, filename, size);
        if (!validationResult.isValid()) {
            this.throwWebException(validationResult.getErrorMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (!(tempAvatarResult = this.avatarPickerHelper.upload(validationResult.getInputStream(), filename, validationResult.getContentType(), validationResult.getSize(), ownerId, iconType)).isValid()) {
            this.throwWebException(tempAvatarResult.getErrorCollection());
        }
        AvatarCroppingBean croppingInstructions = AvatarBeanFactory.createTemporaryAvatarCroppingInstructions((AvatarPickerHelperImpl.TemporaryAvatarBean)tempAvatarResult.getResult());
        if (((AvatarPickerHelperImpl.TemporaryAvatarBean)tempAvatarResult.getResult()).isCroppingNeeded()) {
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)croppingInstructions).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
        }
        return this.createAvatarFromTemporary(iconType, ownerId, croppingInstructions);
    }

    public Response storeTemporaryAvatarUsingMultiPart(IconType iconType, String ownerId, FilePart filePart, HttpServletRequest request) {
        String filename = filePart.getName();
        AttachmentHelper.ValidationResult validationResult = this.attachmentHelper.validate(request, filename, null);
        if (!validationResult.isValid()) {
            return this.returnErrorMessagesAsHtml(Lists.newArrayList((Object[])new String[]{validationResult.getErrorMessage()}));
        }
        String fullPath = filePart.getName();
        String fileName = fullPath.substring(fullPath.lastIndexOf("\\") + 1, fullPath.length());
        try {
            AvatarPickerHelperImpl.Result tempAvatarResult = this.avatarPickerHelper.upload(filePart.getInputStream(), fileName, filePart.getContentType(), -1L, ownerId, iconType);
            if (!tempAvatarResult.isValid()) {
                return this.returnErrorMessagesAsHtml(tempAvatarResult.getErrorCollection().getErrorMessages());
            }
            AvatarPickerHelperImpl.TemporaryAvatarBean temporaryAvatarBean = (AvatarPickerHelperImpl.TemporaryAvatarBean)tempAvatarResult.getResult();
            if (temporaryAvatarBean.isCroppingNeeded()) {
                return Response.status((Response.Status)Response.Status.CREATED).entity((Object)("<html><body><textarea>{\"url\": \"" + temporaryAvatarBean.getUrl() + "\",\"cropperWidth\": \"" + temporaryAvatarBean.getCropperWidth() + "\",\"cropperOffsetX\": \"" + temporaryAvatarBean.getCropperOffsetX() + "\",\"cropperOffsetY\": \"" + temporaryAvatarBean.getCropperOffsetY() + "\",\"isCroppingNeeded\": \"" + temporaryAvatarBean.isCroppingNeeded() + "\"}</textarea></body></html>")).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
            }
            Selection selection = new Selection(temporaryAvatarBean.getCropperOffsetX(), temporaryAvatarBean.getCropperOffsetY(), temporaryAvatarBean.getCropperWidth(), temporaryAvatarBean.getCropperWidth());
            AvatarPickerHelperImpl.Result conversionResult = this.avatarPickerHelper.convertTemporaryToReal(ownerId, iconType, selection);
            if (!conversionResult.isValid()) {
                return this.returnErrorMessagesAsHtml(conversionResult.getErrorCollection().getErrorMessages());
            }
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)("<html><body><textarea>{\"id\": \"" + ((Avatar)conversionResult.getResult()).getId() + "\"}</textarea></body></html>")).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Response cropTemporaryAvatar(IconType iconType, String ownerId, AvatarCroppingBean croppingInstructions) {
        Selection selection = new Selection(croppingInstructions.getCropperOffsetX(), croppingInstructions.getCropperOffsetY(), croppingInstructions.getCropperWidth(), croppingInstructions.getCropperWidth());
        AvatarPickerHelperImpl.Result cropResult = this.avatarPickerHelper.cropTemporary(ownerId, iconType, selection);
        if (!cropResult.isValid()) {
            this.throwWebException(cropResult.getErrorCollection());
        }
        return Response.status((Response.Status)Response.Status.OK).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
    }

    public Response deleteAvatar(@PathParam(value="id") Long id) {
        Avatar avatar = this.avatarManager.getById(id);
        if (avatar == null) {
            throw new NotFoundWebException();
        }
        if (!this.avatarManager.userCanDelete(this.authContext.getLoggedInUser(), avatar)) {
            throw new ForbiddenWebException();
        }
        boolean deleted = this.avatarManager.delete(id, true);
        if (deleted) {
            return Response.noContent().cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
    }

    private AttachmentHelper.ValidationResult validateAttachment(HttpServletRequest request, @Nullable String filename, @Nullable Long size) {
        AttachmentHelper.ValidationResult validationResult = this.attachmentHelper.validate(request, filename, size);
        if (!validationResult.isValid()) {
            if (validationResult.getErrorType() == AttachmentHelper.ValidationError.XSRF_TOKEN_INVALID) {
                this.throwWebException(this.authContext.getI18nHelper().getText("xsrf.error.title"), ErrorCollection.Reason.FORBIDDEN);
            } else if (validationResult.getErrorType() == AttachmentHelper.ValidationError.ATTACHMENT_IO_SIZE) {
                String message = this.authContext.getI18nHelper().getText("attachfile.error.io.size", filename);
                this.throwWebException(message, ErrorCollection.Reason.SERVER_ERROR);
            } else {
                String message = this.authContext.getI18nHelper().getText("attachfile.error.io.error", filename, validationResult.getErrorMessage());
                this.throwWebException(message, ErrorCollection.Reason.SERVER_ERROR);
            }
        }
        return validationResult;
    }

    private Response returnErrorMessagesAsHtml(Collection<String> errorMessages) {
        String errorMsgs = "";
        String sep = "";
        for (String errorMessage : errorMessages) {
            errorMsgs = errorMsgs + "\"" + JSONEscaper.escape((String)errorMessage) + "\"" + sep;
            sep = ",";
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)("<html><body><textarea>{\"errorMessages\": [" + errorMsgs + "]}</textarea></body></html>")).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
    }

    private void throwWebException(String message, ErrorCollection.Reason reason) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(message, reason);
        this.throwWebException((com.atlassian.jira.util.ErrorCollection)errorCollection);
    }

    private void throwWebException(com.atlassian.jira.util.ErrorCollection errorCollection) {
        throw new RESTException(ErrorCollection.of(errorCollection));
    }
}

