/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bc.issue.watcher.WatchingDisabledException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.NotificationJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.notification.AdhocNotificationService;
import com.atlassian.jira.notification.AdhocNotificationServiceImpl;
import com.atlassian.jira.notification.NotificationBuilder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateRequest;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.property.PropertiesBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.IssuePicker;
import com.atlassian.jira.rest.util.ProjectKeyOrId;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.util.RestIssueFinder;
import com.atlassian.jira.rest.v2.entity.property.IssuePropertiesLoader;
import com.atlassian.jira.rest.v2.issue.ArchiveIssueResource;
import com.atlassian.jira.rest.v2.issue.AssignIssueResource;
import com.atlassian.jira.rest.v2.issue.CommentResource;
import com.atlassian.jira.rest.v2.issue.CreateIssueResource;
import com.atlassian.jira.rest.v2.issue.CreateMetaIssueTypeBean;
import com.atlassian.jira.rest.v2.issue.DeleteIssueResource;
import com.atlassian.jira.rest.v2.issue.EditMetaBean;
import com.atlassian.jira.rest.v2.issue.FieldMetaBean;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.IssueBeanBuilder2;
import com.atlassian.jira.rest.v2.issue.IssueUpdateBean;
import com.atlassian.jira.rest.v2.issue.IssuesUpdateBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.RemoteIssueLinkResource;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.TransitionBean;
import com.atlassian.jira.rest.v2.issue.TransitionsMetaBean;
import com.atlassian.jira.rest.v2.issue.UpdateIssueResource;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.VoteBean;
import com.atlassian.jira.rest.v2.issue.WatchersBean;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.issue.watcher.WatchersFinder;
import com.atlassian.jira.rest.v2.issue.worklog.IssueWorklogResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.OrderByRequest;
import com.atlassian.jira.util.OrderByRequestParser;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.mail.MailFactory;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opensymphony.workflow.loader.ActionDescriptor;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="issue")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueResource {
    private static final int MAX_PAGE_SIZE = 1000;
    private static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final RestIssueFinder issueFinder;
    private final UserManager userManager;
    private final IssueWorkflowManager issueWorkflowManager;
    private final JiraAuthenticationContext authContext;
    private final VoteService voteService;
    private final I18nHelper i18n;
    private final WatchersFinder watchersFinder;
    private final WatcherService watcherService;
    private final AdhocNotificationService notificationService;
    private final BeanBuilderFactory beanBuilderFactory;
    private final UriInfo contextUriInfo;
    private final AssignIssueResource assignIssueResource;
    private final CreateIssueResource createIssueResource;
    private final DeleteIssueResource deleteIssueResource;
    private final ArchiveIssueResource archiveIssueResource;
    private final UpdateIssueResource updateIssueResource;
    private final RemoteIssueLinkResource remoteIssueLinkResource;
    private final IssueWorklogResource issueWorklogResource;
    private final CommentResource commentResource;
    private final JiraBaseUrls jiraBaseUrls;
    private final IssuePicker issuePicker;
    private final OrderByRequestParser orderByRequestParser;
    private final ResponseFactory responseFactory;
    private final IssuePropertiesLoader issuePropertiesLoader;
    private final UserIssueHistoryManager userIssueHistoryManager;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final ResourceUriBuilder resourceUriBuilder;

    @Inject
    public IssueResource(JiraAuthenticationContext authContext, UserManager userManager, VoteService voteService, I18nHelper i18n, WatchersFinder watchersFinder, WatcherService watcherService, BeanBuilderFactory beanBuilderFactory, UriInfo contextUriInfo, RestIssueFinder issueFinder, CreateIssueResource createIssueResource, UpdateIssueResource updateIssueResource, DeleteIssueResource deleteIssueResource, ArchiveIssueResource archiveIssueResource, RemoteIssueLinkResource remoteIssueLinkResource, IssueWorklogResource issueWorklogResource, CommentResource commentResource, IssueWorkflowManager issueWorkflowManager, AssignIssueResource assignIssueResource, AdhocNotificationService notificationService, JiraBaseUrls jiraBaseUrls, IssuePicker issuePicker, OrderByRequestParser orderByRequestParser, ResponseFactory responseFactory, IssuePropertiesLoader issuePropertiesLoader, UserIssueHistoryManager userIssueHistoryManager, PermissionManager permissionManager, ProjectManager projectManager, ResourceUriBuilder resourceUriBuilder) {
        this.jiraBaseUrls = jiraBaseUrls;
        this.issuePicker = issuePicker;
        this.orderByRequestParser = orderByRequestParser;
        this.responseFactory = responseFactory;
        this.issuePropertiesLoader = issuePropertiesLoader;
        this.authContext = (JiraAuthenticationContext)Assertions.notNull((Object)authContext);
        this.userManager = (UserManager)Assertions.notNull((Object)userManager);
        this.voteService = (VoteService)Assertions.notNull((Object)voteService);
        this.i18n = (I18nHelper)Assertions.notNull((Object)i18n);
        this.watchersFinder = (WatchersFinder)Assertions.notNull((Object)watchersFinder);
        this.watcherService = (WatcherService)Assertions.notNull((Object)watcherService);
        this.beanBuilderFactory = (BeanBuilderFactory)Assertions.notNull((Object)beanBuilderFactory);
        this.contextUriInfo = (UriInfo)Assertions.notNull((Object)contextUriInfo);
        this.issueFinder = (RestIssueFinder)Assertions.notNull((Object)issueFinder);
        this.createIssueResource = (CreateIssueResource)Assertions.notNull((Object)createIssueResource);
        this.updateIssueResource = (UpdateIssueResource)Assertions.notNull((Object)updateIssueResource);
        this.deleteIssueResource = (DeleteIssueResource)Assertions.notNull((Object)deleteIssueResource);
        this.archiveIssueResource = (ArchiveIssueResource)Assertions.notNull((Object)archiveIssueResource);
        this.remoteIssueLinkResource = (RemoteIssueLinkResource)Assertions.notNull((Object)remoteIssueLinkResource);
        this.issueWorklogResource = (IssueWorklogResource)Assertions.notNull((Object)issueWorklogResource);
        this.commentResource = (CommentResource)Assertions.notNull((Object)commentResource);
        this.issueWorkflowManager = (IssueWorkflowManager)Assertions.notNull((Object)issueWorkflowManager);
        this.assignIssueResource = (AssignIssueResource)Assertions.notNull((Object)assignIssueResource);
        this.notificationService = (AdhocNotificationService)Assertions.notNull((Object)notificationService);
        this.userIssueHistoryManager = (UserIssueHistoryManager)Assertions.notNull((Object)userIssueHistoryManager);
        this.permissionManager = (PermissionManager)Assertions.notNull((Object)permissionManager);
        this.projectManager = (ProjectManager)Assertions.notNull((Object)projectManager);
        this.resourceUriBuilder = resourceUriBuilder;
    }

    @GET
    @Path(value="{issueIdOrKey}/transitions")
    public Response getTransitions(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="transitionId") String transitionId) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        try {
            if (StringUtils.isNotBlank((CharSequence)transitionId)) {
                Integer.valueOf(transitionId);
            }
        }
        catch (NumberFormatException e) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.transition.error.id.not.integer"));
        }
        List actions = this.issueWorkflowManager.getSortedAvailableActions(issue, this.authContext.getUser());
        ArrayList<TransitionBean> transitions = new ArrayList<TransitionBean>(actions.size());
        for (ActionDescriptor action : actions) {
            if (StringUtils.isNotBlank((CharSequence)transitionId) && !Integer.valueOf(transitionId).equals(action.getId())) continue;
            TransitionBean transitionMetaBean = this.beanBuilderFactory.newTransitionMetaBeanBuilder().issue(issue).action(action).build();
            transitions.add(transitionMetaBean);
        }
        TransitionsMetaBean transitionsMetaBean = new TransitionsMetaBean(transitions);
        return Response.ok((Object)transitionsMetaBean).cacheControl(CacheControl.never()).build();
    }

    @Path(value="picker")
    @GET
    public Response getIssuePickerResource(@QueryParam(value="query") String query, @QueryParam(value="currentJQL") String currentJQL, @QueryParam(value="currentIssueKey") String currentIssueKey, @QueryParam(value="currentProjectId") String currentProjectId, @QueryParam(value="showSubTasks") boolean showSubTasks, @QueryParam(value="showSubTaskParent") boolean showSubTaskParent) {
        return this.issuePicker.getIssuesResponse((Option<String>)Option.option((Object)query), currentJQL, currentIssueKey, currentProjectId, showSubTasks, showSubTaskParent);
    }

    @POST
    @Path(value="{issueIdOrKey}/transitions")
    public Response doTransition(@PathParam(value="issueIdOrKey") String issueIdOrKey, IssueUpdateBean issueUpdateBean) {
        if (issueUpdateBean.getTransition() == null) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.transition.error.no.transition"));
        }
        try {
            Integer.parseInt(issueUpdateBean.getTransition().getId());
        }
        catch (NumberFormatException e) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.transition.error.id.not.integer"));
        }
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.updateIssueResource.transitionIssue(issue, issueUpdateBean);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/votes")
    public Response removeVote(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        VoteService.VoteValidationResult validationResult = this.voteService.validateRemoveVote(this.authContext.getUser(), this.authContext.getUser(), issue);
        if (!validationResult.isValid()) {
            throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(validationResult.getErrorCollection()));
        }
        this.voteService.removeVote(this.authContext.getUser(), validationResult);
        return IssueResource.NO_CONTENT();
    }

    @POST
    @Path(value="{issueIdOrKey}/votes")
    public Response addVote(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        VoteService.VoteValidationResult validationResult = this.voteService.validateAddVote(this.authContext.getUser(), this.authContext.getUser(), issue);
        if (!validationResult.isValid()) {
            throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(validationResult.getErrorCollection()));
        }
        this.voteService.addVote(this.authContext.getUser(), validationResult);
        return IssueResource.NO_CONTENT();
    }

    @GET
    @Path(value="{issueIdOrKey}/votes")
    public Response getVotes(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        ApplicationUser user = this.authContext.getUser();
        if (this.voteService.isVotingEnabled()) {
            boolean hasVoted = this.voteService.hasVoted(issue, user);
            ServiceOutcome outcome = this.voteService.viewVoters(issue, user);
            ArrayList voters = outcome.isValid() ? new ArrayList(Transformed.collection((Collection)((Collection)outcome.getReturnedValue()), (Function)new Function<ApplicationUser, UserBean>(){

                public UserBean apply(ApplicationUser input) {
                    return UserBeanBuilder.shortBuilder(IssueResource.this.jiraBaseUrls).user(input).buildShort();
                }
            })) : new ArrayList();
            URI selfUri = this.resourceUriBuilder.getBuilder(this.contextUriInfo.getBaseUriBuilder(), IssueResource.class).path(issue.getKey()).path("votes").build(new Object[0]);
            VoteBean voteBean = new VoteBean(selfUri, hasVoted, issue.getVotes(), voters);
            return Response.ok((Object)voteBean).cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(this.i18n.getText("issue.operations.voting.disabled")));
    }

    @GET
    @Path(value="{issueIdOrKey}")
    public Response getIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="fields") List<StringList> fields, @QueryParam(value="expand") String expand, @QueryParam(value="properties") List<StringList> properties, @QueryParam(value="updateHistory") boolean updateHistory) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        IncludedFields include = IncludedFields.includeAllByDefault(fields);
        IssueBeanBuilder2 issueBeanBuilder = this.beanBuilderFactory.newIssueBeanBuilder2(include, expand);
        IssueBean bean = issueBeanBuilder.build(issue);
        ApplicationUser user = this.authContext.getLoggedInUser();
        PropertiesBean propertiesBean = this.issuePropertiesLoader.getProperties(user, issue, properties);
        bean.setProperties(propertiesBean);
        if (updateHistory && user != null) {
            this.userIssueHistoryManager.addIssueToHistory(user, issue);
        }
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{issueIdOrKey}/watchers")
    public Response getIssueWatchers(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        WatchersBean watchers = this.watchersFinder.getWatchers(issue, this.authContext.getUser());
        return Response.ok((Object)watchers).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{issueIdOrKey}/watchers")
    public Response addWatcher(@PathParam(value="issueIdOrKey") String issueIdOrKey, String userName) {
        try {
            ApplicationUser watchUser = this.getUserFromPost(userName);
            if (watchUser == null) {
                return this.BAD_REQUEST();
            }
            Issue issue = this.issueFinder.find(issueIdOrKey);
            ServiceOutcome outcome = this.watcherService.addWatcher(issue, this.authContext.getUser(), watchUser);
            if (!outcome.isValid()) {
                throw new NotAuthorisedWebException(ErrorCollection.of(outcome.getErrorCollection()));
            }
            return IssueResource.NO_CONTENT();
        }
        catch (WatchingDisabledException e) {
            throw new NotFoundWebException(e);
        }
    }

    private ApplicationUser getUserFromPost(String body) {
        if (StringUtils.isEmpty((CharSequence)body)) {
            return this.authContext.getUser();
        }
        JsonFactory factory = OBJECT_MAPPER.getJsonFactory();
        try {
            JsonParser jp = factory.createJsonParser(body);
            JsonNode obj = (JsonNode)OBJECT_MAPPER.readTree(jp);
            if (obj.isTextual()) {
                String userName = obj.asText();
                if (StringUtils.isEmpty((CharSequence)userName)) {
                    return this.authContext.getUser();
                }
                return this.userManager.getUserByName(userName);
            }
            throw new WebApplicationException(this.BAD_REQUEST());
        }
        catch (JsonParseException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
    }

    @DELETE
    @Path(value="{issueIdOrKey}/watchers")
    public Response removeWatcher(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="username") String userName) {
        try {
            if (userName == null) {
                return this.BAD_REQUEST();
            }
            ApplicationUser unwatchUser = this.userManager.getUserByNameEvenWhenUnknown(userName);
            Issue issue = this.issueFinder.find(issueIdOrKey);
            ServiceOutcome outcome = this.watcherService.removeWatcher(issue, this.authContext.getUser(), unwatchUser);
            if (!outcome.isValid()) {
                throw new NotAuthorisedWebException(ErrorCollection.of(outcome.getErrorCollection()));
            }
            return IssueResource.NO_CONTENT();
        }
        catch (WatchingDisabledException e) {
            throw new NotFoundWebException();
        }
    }

    @POST
    public Response createIssue(@QueryParam(value="updateHistory") @DefaultValue(value="false") boolean updateHistory, IssueUpdateBean createRequest) {
        return this.createIssueResource.createIssue(createRequest, updateHistory, this.contextUriInfo);
    }

    @POST
    @Path(value="/bulk")
    public Response createIssues(IssuesUpdateBean createRequest) {
        return this.createIssueResource.createIssues(createRequest, this.contextUriInfo);
    }

    @DELETE
    @Path(value="{issueIdOrKey}")
    public Response deleteIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="deleteSubtasks") String deleteSubtasks) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.deleteIssueResource.deleteIssue(issue, deleteSubtasks, this.contextUriInfo);
    }

    @PUT
    @Path(value="{issueIdOrKey}/archive")
    public Response archiveIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="notifyUsers") @DefaultValue(value="true") boolean notifyUsers) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.archiveIssueResource.archiveIssue(issue.getKey(), notifyUsers);
    }

    @POST
    @Path(value="archive")
    @Produces(value={"text/plain"})
    public Response archiveIssues(@RequestBody List<String> issueKeys, @QueryParam(value="notifyUsers") @DefaultValue(value="false") boolean notifyUsers) {
        StreamingOutput streamingOutput = output -> {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
            for (String issueKey : issueKeys) {
                Response response = this.archiveIssueResource.archiveIssue(issueKey, notifyUsers);
                writer.write(String.format("%s, %d %s\n", issueKey, response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus())));
                writer.flush();
            }
        };
        return Response.ok((Object)streamingOutput).build();
    }

    @PUT
    @Path(value="{issueIdOrKey}/restore")
    public Response restoreIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="notifyUsers") @DefaultValue(value="true") boolean notifyUsers) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.archiveIssueResource.restoreIssue(issue.getKey(), notifyUsers);
    }

    @GET
    @Path(value="createmeta/{projectIdOrKey}/issuetypes")
    public Response getCreateIssueMetaProjectIssueTypes(@PathParam(value="projectIdOrKey") String projectIdOrKey, @QueryParam(value="startAt") @DefaultValue(value="0") long startAt, @QueryParam(value="maxResults") @DefaultValue(value="50") int maxResults) {
        try {
            if (!this.hasUserCreateIssuePermissionOnProject(projectIdOrKey)) {
                throw new WebApplicationException(this.BAD_REQUEST());
            }
            PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)Math.min(maxResults, 1000));
            Page<CreateMetaIssueTypeBean> issueTypesForProject = this.beanBuilderFactory.newCreateMetaIssueTypeBeanBuilder(projectIdOrKey).buildPaged(pageRequest);
            return Response.ok(PageBean.from(pageRequest, issueTypesForProject).build(java.util.function.Function.identity())).cacheControl(CacheControl.never()).build();
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
    }

    @GET
    @Path(value="createmeta/{projectIdOrKey}/issuetypes/{issueTypeId}")
    public Response getCreateIssueMetaFields(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="issueTypeId") String issueTypeId, @QueryParam(value="startAt") @DefaultValue(value="0") long startAt, @QueryParam(value="maxResults") @DefaultValue(value="50") int maxResults) {
        try {
            if (!this.hasUserCreateIssuePermissionOnProject(projectIdOrKey)) {
                throw new WebApplicationException(this.BAD_REQUEST());
            }
            PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)Math.min(maxResults, 1000));
            Page<FieldMetaBean> fieldMetaBeanPage = this.beanBuilderFactory.newCreateMetaFieldBeanBuilder(projectIdOrKey, issueTypeId).buildPaged(pageRequest);
            return Response.ok(PageBean.from(pageRequest, fieldMetaBeanPage).build(java.util.function.Function.identity())).cacheControl(CacheControl.never()).build();
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
    }

    @GET
    @Path(value="{issueIdOrKey}/editmeta")
    public Response getEditIssueMeta(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        EditMetaBean bean = this.beanBuilderFactory.newEditMetaBeanBuilder().issue(issue).build();
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @PUT
    @Path(value="{issueIdOrKey}")
    public Response editIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="notifyUsers") @DefaultValue(value="true") boolean notifyUsers, IssueUpdateBean updateRequest) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.updateIssueResource.editIssue(issue, updateRequest, notifyUsers);
    }

    @PUT
    @Path(value="{issueIdOrKey}/assignee")
    public Response assign(@PathParam(value="issueIdOrKey") String issueIdOrKey, UserBean assigneeBean) {
        String assigneeName = assigneeBean == null ? null : assigneeBean.getName();
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.assignIssueResource.assignIssue(issue, assigneeName);
    }

    @GET
    @Path(value="{issueIdOrKey}/remotelink")
    public Response getRemoteIssueLinks(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="globalId") String globalId) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.remoteIssueLinkResource.getRemoteIssueLinks(issue, globalId);
    }

    @GET
    @Path(value="{issueIdOrKey}/remotelink/{linkId}")
    public Response getRemoteIssueLinkById(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="linkId") String linkId) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.remoteIssueLinkResource.getRemoteIssueLinkById(issue, linkId);
    }

    @POST
    @Path(value="{issueIdOrKey}/remotelink")
    public Response createOrUpdateRemoteIssueLink(@PathParam(value="issueIdOrKey") String issueIdOrKey, RemoteIssueLinkCreateOrUpdateRequest request) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.remoteIssueLinkResource.createOrUpdateRemoteIssueLink(issue, request, this.contextUriInfo);
    }

    @PUT
    @Path(value="{issueIdOrKey}/remotelink/{linkId}")
    public Response updateRemoteIssueLink(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="linkId") String linkId, RemoteIssueLinkCreateOrUpdateRequest updateRequest) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.remoteIssueLinkResource.updateRemoteIssueLink(issue, linkId, updateRequest);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/remotelink/{linkId}")
    public Response deleteRemoteIssueLinkById(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="linkId") String remoteIssueLinkId) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.remoteIssueLinkResource.deleteRemoteIssueLinkById(issue, remoteIssueLinkId);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/remotelink")
    public Response deleteRemoteIssueLinkByGlobalId(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="globalId") String globalId) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.remoteIssueLinkResource.deleteRemoteIssueLinkByGlobalId(issue, globalId);
    }

    @GET
    @Path(value="{issueIdOrKey}/worklog")
    public Response getIssueWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.issueWorklogResource.getIssueWorklogs(issue);
    }

    @GET
    @Path(value="{issueIdOrKey}/worklog/{id}")
    public Response getWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String worklogId) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.issueWorklogResource.getWorklogForIssue(worklogId, issue);
    }

    @PUT
    @Path(value="{issueIdOrKey}/worklog/{id}")
    public Response updateWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String worklogId, @QueryParam(value="adjustEstimate") String adjustEstimate, @QueryParam(value="newEstimate") String newEstimate, WorklogJsonBean request) {
        if (request.getId() != null && !request.getId().equals(worklogId)) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.worklog.error.id.mismatch"));
        }
        request.setId(worklogId);
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.issueWorklogResource.updateWorklog(issue, request, new IssueWorklogResource.WorklogAdjustmentRequest(adjustEstimate, newEstimate, null, null), this.contextUriInfo);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/worklog/{id}")
    public Response deleteWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String worklogId, @QueryParam(value="adjustEstimate") String adjustEstimate, @QueryParam(value="newEstimate") String newEstimate, @QueryParam(value="increaseBy") String increaseBy) {
        WorklogJsonBean request = new WorklogJsonBean();
        request.setId(worklogId);
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.issueWorklogResource.deleteWorklog(issue, request, new IssueWorklogResource.WorklogAdjustmentRequest(adjustEstimate, newEstimate, null, increaseBy), this.contextUriInfo);
    }

    @POST
    @Path(value="{issueIdOrKey}/worklog")
    public Response addWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="adjustEstimate") String adjustEstimate, @QueryParam(value="newEstimate") String newEstimate, @QueryParam(value="reduceBy") String reduceBy, WorklogJsonBean request) {
        Issue issue = this.issueFinder.find(issueIdOrKey);
        return this.issueWorklogResource.addWorklog(issue, request, new IssueWorklogResource.WorklogAdjustmentRequest(adjustEstimate, newEstimate, reduceBy, null), this.contextUriInfo);
    }

    @GET
    @Path(value="{issueIdOrKey}/comment")
    public Response getComments(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="expand") String expand) {
        Either maybeOrderByOrError = orderBy != null ? this.orderByRequestParser.parse(orderBy, CommentResource.CommentField.class).map(Option::some) : Either.right((Object)Option.none());
        return (Response)maybeOrderByOrError.leftMap(this.responseFactory::errorResponse).left().on(maybeOrderBy -> this.commentResource.getComments(issueIdOrKey, expand, PageRequests.request((Long)startAt, (Integer)maxResults), (Option<OrderByRequest<CommentResource.CommentField>>)maybeOrderBy));
    }

    @GET
    @Path(value="{issueIdOrKey}/pinned-comments")
    public Response getPinnedComments(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        return this.commentResource.getPinnedComments(issueIdOrKey);
    }

    @GET
    @Path(value="{issueIdOrKey}/comment/{id}")
    public Response getComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String commentId, @QueryParam(value="expand") String expand) {
        return this.commentResource.getComment(issueIdOrKey, commentId, expand);
    }

    @PUT
    @Path(value="{issueIdOrKey}/comment/{id}")
    public Response updateComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String commentId, @QueryParam(value="expand") String expand, CommentJsonBean request) {
        return this.commentResource.updateComment(issueIdOrKey, commentId, expand, request);
    }

    @PUT
    @Path(value="{issueIdOrKey}/comment/{id}/pin")
    public Response setPinComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String commentId, boolean pinned) {
        return this.commentResource.setPinComment(issueIdOrKey, commentId, pinned);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/comment/{id}")
    public Response deleteComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String commentId) {
        return this.commentResource.deleteComment(issueIdOrKey, commentId);
    }

    @POST
    @Path(value="{issueIdOrKey}/comment")
    public Response addComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="expand") String expand, CommentJsonBean request) {
        return this.commentResource.addComment(issueIdOrKey, expand, request);
    }

    @POST
    @Path(value="{issueIdOrKey}/notify")
    public Response notify(@PathParam(value="issueIdOrKey") String issueIdOrKey, NotificationJsonBean request) {
        AdhocNotificationService.ValidateNotificationResult result;
        if (MailFactory.getSettings().isSendingDisabled()) {
            throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(this.i18n.getText("rest.error.outgoing.mail.disabled")));
        }
        if (MailFactory.getServerManager().getDefaultSMTPMailServer() == null) {
            throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(this.i18n.getText("rest.error.no.smtp.defined")));
        }
        ApplicationUser user = this.authContext.getUser();
        Issue issue = this.issueFinder.find(issueIdOrKey);
        ErrorCollection errors = ErrorCollection.of(new String[0]);
        ServiceOutcome notificationBuilder = AdhocNotificationServiceImpl.makeBuilder((NotificationBuilder)this.notificationService.makeBuilder(), (NotificationJsonBean)request, (I18nHelper)this.i18n);
        if (!notificationBuilder.isValid()) {
            errors.addErrorCollection(notificationBuilder.getErrorCollection());
        }
        if (!(result = this.notificationService.validateNotification((NotificationBuilder)notificationBuilder.getReturnedValue(), user, issue)).isValid()) {
            throw new RESTException(Response.Status.BAD_REQUEST, errors.addErrorCollection(result.getErrorCollection()));
        }
        this.notificationService.sendNotification(result);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    protected Response BAD_REQUEST() {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
    }

    protected static Response NO_CONTENT() {
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    public Collection<FieldMetaBean> getRequiredFields(FieldScreenRenderer fieldScreenRenderer, Issue issue) {
        ArrayList<FieldMetaBean> fields = new ArrayList<FieldMetaBean>();
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (Object fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                OrderableField orderableField;
                if (!fieldScreenRenderLayoutItem.isShow(issue) || !"resolution".equals((orderableField = fieldScreenRenderLayoutItem.getOrderableField()).getId())) continue;
                fieldScreenRenderLayoutItem = new FieldScreenRenderLayoutItemImpl(fieldScreenRenderLayoutItem.getFieldScreenLayoutItem(), fieldScreenRenderLayoutItem.getFieldLayoutItem()){

                    public boolean isRequired() {
                        return true;
                    }
                };
            }
        }
        return fields;
    }

    private boolean hasUserCreateIssuePermissionOnProject(String projectIdOrKey) {
        Project project = (Project)ProjectKeyOrId.parse(projectIdOrKey).fold(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0), arg_0 -> ((ProjectManager)this.projectManager).getProjectObjByKey(arg_0));
        return project != null && this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, this.authContext.getLoggedInUser());
    }
}

