/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.SecurityLevelJsonBean;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="securitylevel")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueSecurityLevelResource {
    private IssueSecurityLevelManager issueSecurityLevelManager;
    private JiraBaseUrls jiraBaseUrls;
    private I18nHelper i18n;

    private IssueSecurityLevelResource() {
    }

    @Inject
    public IssueSecurityLevelResource(IssueSecurityLevelManager issueSecurityLevelManager, JiraBaseUrls jiraBaseUrls, I18nHelper i18n) {
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.i18n = i18n;
    }

    @GET
    @Path(value="{id}")
    public Response getIssuesecuritylevel(@PathParam(value="id") String issueSecurityLevelId) {
        try {
            IssueSecurityLevel issueSecurityLevel = this.issueSecurityLevelManager.getSecurityLevel(Long.parseLong(issueSecurityLevelId));
            if (issueSecurityLevel == null) {
                throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("createissue.error.security.level.not.found", issueSecurityLevelId)));
            }
            Response.ResponseBuilder rb = Response.ok((Object)SecurityLevelJsonBean.shortBean((IssueSecurityLevel)issueSecurityLevel, (JiraBaseUrls)this.jiraBaseUrls));
            return rb.cacheControl(CacheControl.never()).build();
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("createissue.error.security.level.not.found", issueSecurityLevelId)));
        }
    }
}

