/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.config.SubTaskService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilderFactory;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.issue.IssueFinder;
import com.atlassian.jira.rest.v2.issue.IssueSubTaskMovePositionBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="issue/{issueIdOrKey}/subtask")
@Produces(value={"application/json"})
public class IssueSubTaskResource {
    private final SubTaskService subTaskService;
    private final IssueFinder issueFinder;
    private final JiraAuthenticationContext authenticationContext;
    private final IssueLinksBeanBuilderFactory issueLinksBeanBuilderFactory;
    private final ResponseFactory responseFactory;

    @Inject
    public IssueSubTaskResource(SubTaskService subTaskService, IssueFinder issueFinder, JiraAuthenticationContext authenticationContext, IssueLinksBeanBuilderFactory issueLinksBeanBuilderFactory, ResponseFactory responseFactory) {
        this.subTaskService = subTaskService;
        this.issueFinder = issueFinder;
        this.authenticationContext = authenticationContext;
        this.issueLinksBeanBuilderFactory = issueLinksBeanBuilderFactory;
        this.responseFactory = responseFactory;
    }

    @GET
    public Response getSubTasks(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        return this.withIssue(issueIdOrKey, issue -> {
            IssueLinksBeanBuilder issueLinkBeanBuilder = this.issueLinksBeanBuilderFactory.newIssueLinksBeanBuilder(issue);
            List subtaskLinks = issueLinkBeanBuilder.buildSubtaskLinks();
            return this.responseFactory.okNoCache(subtaskLinks);
        });
    }

    @GET
    @Path(value="move")
    public Response canMoveSubTask(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        return this.withIssue(issueIdOrKey, issue -> Response.ok((Object)this.subTaskService.canMoveSubtask(this.authenticationContext.getLoggedInUser(), issue)).build());
    }

    @POST
    @Path(value="move")
    @Consumes(value={"application/json"})
    public Response moveSubTasks(@PathParam(value="issueIdOrKey") String issueIdOrKey, IssueSubTaskMovePositionBean position) {
        return this.withIssue(issueIdOrKey, issue -> {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            ServiceResult result = this.subTaskService.moveSubTask(user, issue, Long.valueOf(position.getOriginal()), Long.valueOf(position.getCurrent()));
            if (!result.isValid()) {
                return this.responseFactory.errorResponse(result.getErrorCollection());
            }
            return Response.noContent().cacheControl(CacheControl.never()).build();
        });
    }

    private Response withIssue(String issueIdOrKey, Function<Issue, Response> fn) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        if (issue != null) {
            return fn.apply((Issue)issue);
        }
        return this.responseFactory.notFound("", new String[0]);
    }
}

