/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.issue.link.RemoteIssueLinkService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateRequest;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateResponse;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.RemoteIssueLinkBean;
import com.atlassian.jira.rest.v2.issue.RemoteIssueLinkBeanBuilder;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public class RemoteIssueLinkResource {
    private final RemoteIssueLinkService remoteIssueLinkService;
    private final BeanBuilderFactory beanBuilderFactory;
    private final I18nHelper i18n;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Inject
    public RemoteIssueLinkResource(RemoteIssueLinkService remoteIssueLinkService, BeanBuilderFactory beanBuilderFactory, I18nHelper i18n, JiraAuthenticationContext jiraAuthenticationContext) {
        this.remoteIssueLinkService = remoteIssueLinkService;
        this.beanBuilderFactory = beanBuilderFactory;
        this.i18n = i18n;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public Response getRemoteIssueLinks(Issue issue, String globalId) {
        Object entity;
        ApplicationUser user = this.callingUser();
        if (globalId != null) {
            RemoteIssueLinkService.RemoteIssueLinkResult result = this.remoteIssueLinkService.getRemoteIssueLinkByGlobalId(user, issue, globalId);
            if (!result.isValid()) {
                throw new RESTException(ErrorCollection.of(result.getErrorCollection()));
            }
            entity = this.convertToBean(result.getRemoteIssueLink());
        } else {
            RemoteIssueLinkService.RemoteIssueLinkListResult result = this.remoteIssueLinkService.getRemoteIssueLinksForIssue(user, issue);
            if (!result.isValid()) {
                throw new RESTException(ErrorCollection.of(result.getErrorCollection()));
            }
            entity = this.convertToBeans(result.getRemoteIssueLinks());
        }
        return Response.ok((Object)entity).cacheControl(CacheControl.never()).build();
    }

    public Response getRemoteIssueLinkById(Issue issue, String idString) {
        RemoteIssueLink remoteIssueLink = this.getRemoteIssueLinkPrivate(issue, idString);
        RemoteIssueLinkBean bean = this.beanBuilderFactory.newRemoteIssueLinkBeanBuilder(remoteIssueLink).build();
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    public Response createOrUpdateRemoteIssueLink(Issue issue, RemoteIssueLinkCreateOrUpdateRequest request, UriInfo contextUriInfo) {
        ApplicationUser user = this.callingUser();
        if (request.globalId() != null) {
            RemoteIssueLinkService.RemoteIssueLinkResult result = this.remoteIssueLinkService.getRemoteIssueLinkByGlobalId(user, issue, request.globalId());
            if (result.isValid()) {
                this.updateRemoteIssueLinkPrivate(result.getRemoteIssueLink(), request);
                URI self = RemoteIssueLinkBeanBuilder.createSelfLink(result.getRemoteIssueLink(), issue, contextUriInfo);
                RemoteIssueLinkCreateOrUpdateResponse response = this.newCreateOrUpdateResponse(result.getRemoteIssueLink(), self);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
            }
            if (!this.isValidForCreate(result)) {
                throw new RESTException(ErrorCollection.of(result.getErrorCollection()));
            }
        }
        return this.createRemoteIssueLink(issue, request, contextUriInfo);
    }

    private boolean isValidForCreate(RemoteIssueLinkService.RemoteIssueLinkResult result) {
        if (!result.isValid()) {
            return result.getErrorCollection().getReasons().contains(ErrorCollection.Reason.NOT_FOUND) && result.getErrorCollection().getReasons().size() == 1;
        }
        return true;
    }

    private Response createRemoteIssueLink(Issue issue, RemoteIssueLinkCreateOrUpdateRequest request, UriInfo contextUriInfo) {
        RemoteIssueLink remoteIssueLink = this.buildRemoteIssueLink(issue.getId(), request);
        ApplicationUser user = this.callingUser();
        RemoteIssueLinkService.CreateValidationResult validationResult = this.remoteIssueLinkService.validateCreate(user, remoteIssueLink);
        if (!validationResult.isValid()) {
            throw new RESTException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        RemoteIssueLinkService.RemoteIssueLinkResult result = this.remoteIssueLinkService.create(user, validationResult);
        if (!result.isValid()) {
            throw new RESTException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        URI self = RemoteIssueLinkBeanBuilder.createSelfLink(result.getRemoteIssueLink(), issue, contextUriInfo);
        RemoteIssueLinkCreateOrUpdateResponse response = this.newCreateOrUpdateResponse(result.getRemoteIssueLink(), self);
        return Response.status((Response.Status)Response.Status.CREATED).location(self).entity((Object)response).build();
    }

    public Response updateRemoteIssueLink(Issue issue, String idString, RemoteIssueLinkCreateOrUpdateRequest request) {
        RemoteIssueLink oldRemoteIssueLink = this.getRemoteIssueLinkPrivate(issue, idString);
        this.updateRemoteIssueLinkPrivate(oldRemoteIssueLink, request);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response deleteRemoteIssueLinkById(Issue issue, String idString) {
        RemoteIssueLink remoteIssueLink = this.getRemoteIssueLinkPrivate(issue, idString);
        ApplicationUser user = this.callingUser();
        RemoteIssueLinkService.DeleteValidationResult validationResult = this.remoteIssueLinkService.validateDelete(user, remoteIssueLink.getId());
        if (!validationResult.isValid()) {
            throw new RESTException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        this.remoteIssueLinkService.delete(user, validationResult);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    public Response deleteRemoteIssueLinkByGlobalId(Issue issue, String globalId) {
        ApplicationUser user = this.callingUser();
        RemoteIssueLinkService.DeleteByGlobalIdValidationResult validationResult = this.remoteIssueLinkService.validateDeleteByGlobalId(user, issue, globalId);
        if (!validationResult.isValid()) {
            throw new RESTException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        this.remoteIssueLinkService.deleteByGlobalId(user, validationResult);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private RemoteIssueLink getRemoteIssueLinkPrivate(Issue issue, String idString) {
        Long remoteIssueLinkId = this.getRemoteIssueLinkId(idString);
        RemoteIssueLinkService.RemoteIssueLinkResult result = this.remoteIssueLinkService.getRemoteIssueLink(this.callingUser(), remoteIssueLinkId);
        if (!result.isValid()) {
            throw new RESTException(ErrorCollection.of(result.getErrorCollection()));
        }
        RemoteIssueLink remoteIssueLink = result.getRemoteIssueLink();
        if (remoteIssueLink == null) {
            throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(this.i18n.getText("rest.issue.remotelink.with.id.not.found", idString)));
        }
        if (!issue.getId().equals(remoteIssueLink.getIssueId())) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(this.i18n.getText("rest.issue.remotelink.not.for.issue", idString, issue.getKey())));
        }
        return remoteIssueLink;
    }

    private void updateRemoteIssueLinkPrivate(RemoteIssueLink oldRemoteIssueLink, RemoteIssueLinkCreateOrUpdateRequest request) {
        RemoteIssueLink remoteIssueLink = this.buildRemoteIssueLink(oldRemoteIssueLink.getIssueId(), request, oldRemoteIssueLink.getId());
        ApplicationUser user = this.callingUser();
        RemoteIssueLinkService.UpdateValidationResult validationResult = this.remoteIssueLinkService.validateUpdate(user, remoteIssueLink);
        if (!validationResult.isValid()) {
            throw new RESTException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        RemoteIssueLinkService.RemoteIssueLinkResult result = this.remoteIssueLinkService.update(user, validationResult);
        if (!result.isValid()) {
            throw new RESTException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
    }

    private RemoteIssueLink buildRemoteIssueLink(Long issueId, RemoteIssueLinkCreateOrUpdateRequest request, Long id) {
        return new RemoteIssueLinkBuilder().issueId(issueId).id(id).globalId(request.globalId()).title(request.title()).summary(request.summary()).url(request.url()).iconUrl(request.iconUrl()).iconTitle(request.iconTitle()).relationship(request.relationship()).resolved(request.resolved()).statusIconUrl(request.statusIconUrl()).statusIconTitle(request.statusIconTitle()).statusIconLink(request.statusIconLink()).applicationType(request.applicationType()).applicationName(request.applicationName()).build();
    }

    private RemoteIssueLink buildRemoteIssueLink(Long issueId, RemoteIssueLinkCreateOrUpdateRequest request) {
        return this.buildRemoteIssueLink(issueId, request, null);
    }

    private Long getRemoteIssueLinkId(String idString) {
        Long remoteIssueLinkId;
        try {
            remoteIssueLinkId = Long.parseLong(idString);
        }
        catch (NumberFormatException e) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(this.i18n.getText("rest.issue.remotelink.invalid.id", idString)));
        }
        return remoteIssueLinkId;
    }

    private RemoteIssueLinkBean convertToBean(RemoteIssueLink remoteIssueLink) {
        return this.beanBuilderFactory.newRemoteIssueLinkBeanBuilder(remoteIssueLink).build();
    }

    private List<RemoteIssueLinkBean> convertToBeans(List<RemoteIssueLink> remoteIssueLinks) {
        ArrayList<RemoteIssueLinkBean> beans = new ArrayList<RemoteIssueLinkBean>(remoteIssueLinks.size());
        for (RemoteIssueLink remoteIssueLink : remoteIssueLinks) {
            beans.add(this.convertToBean(remoteIssueLink));
        }
        return beans;
    }

    private RemoteIssueLinkCreateOrUpdateResponse newCreateOrUpdateResponse(RemoteIssueLink remoteIssueLink, URI self) {
        return new RemoteIssueLinkCreateOrUpdateResponse().id(remoteIssueLink.getId()).self(self.toString());
    }

    private ApplicationUser callingUser() {
        return this.jiraAuthenticationContext.getUser();
    }
}

