/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.rest.v2.issue.ScreenBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ScreensWithPaginationJsonBean {
    @JsonProperty
    private Integer startAt;
    @JsonProperty
    private Integer maxResults;
    @JsonProperty
    private Integer total;
    @JsonProperty
    private Collection<ScreenBean> screens;
    public static final ScreensWithPaginationJsonBean DOC_EXAMPLE = new ScreensWithPaginationJsonBean();

    private ScreensWithPaginationJsonBean() {
    }

    public ScreensWithPaginationJsonBean(@Nonnull Integer startAt, @Nonnull Integer maxResults, @Nullable Integer total, Collection<ScreenBean> screens) {
        this.startAt = Objects.requireNonNull(startAt);
        this.maxResults = Objects.requireNonNull(maxResults);
        this.total = total;
        this.screens = (Collection)MoreObjects.firstNonNull(screens, Collections.emptyList());
    }

    @Nonnull
    public Integer getStartAt() {
        return this.startAt;
    }

    public void setStartAt(@Nonnull Integer startAt) {
        this.startAt = startAt;
    }

    @Nonnull
    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(@Nonnull Integer maxResults) {
        this.maxResults = maxResults;
    }

    @Nullable
    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(@Nullable Integer total) {
        this.total = total;
    }

    @Nonnull
    public Collection<ScreenBean> getScreens() {
        return this.screens;
    }

    public void setScreens(@Nonnull Collection<ScreenBean> screens) {
        this.screens = screens;
    }

    static {
        DOC_EXAMPLE.setMaxResults(1);
        DOC_EXAMPLE.setTotal(1);
        DOC_EXAMPLE.setStartAt(0);
        DOC_EXAMPLE.setScreens(Lists.newArrayList((Object[])new ScreenBean[]{ScreenBean.DOC_EXAMPLE}));
    }
}

