/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusCategoryJsonBean;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.StatusCategoryHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="statuscategory")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class StatusCategoryResource {
    private JiraAuthenticationContext authContext;
    private ConstantsService constantsService;
    private StatusCategoryHelper statusCategoryHelper;

    @Inject
    public StatusCategoryResource(JiraAuthenticationContext authContext, ConstantsService constantsService, StatusCategoryHelper statusCategoryHelper) {
        this.authContext = authContext;
        this.constantsService = constantsService;
        this.statusCategoryHelper = statusCategoryHelper;
    }

    private StatusCategoryResource() {
    }

    @GET
    public Response getStatusCategories(@Context Request request, @Context UriInfo uriInfo) {
        ServiceOutcome outcome = this.constantsService.getAllStatusCategories(this.authContext.getUser());
        if (!outcome.isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(outcome.getErrorCollection()));
        }
        Collection returnedValue = (Collection)outcome.getReturnedValue();
        ArrayList<StatusCategoryJsonBean> beans = new ArrayList<StatusCategoryJsonBean>(returnedValue.size());
        for (StatusCategory statusCategory : returnedValue) {
            StatusCategoryJsonBean statusCategoryBean = this.statusCategoryHelper.createStatusCategoryBean(statusCategory, uriInfo, StatusCategoryResource.class);
            beans.add(statusCategoryBean);
        }
        return Response.ok(beans).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{idOrKey}")
    public Response getStatusCategory(@PathParam(value="idOrKey") String idOrKey, @Context Request request, @Context UriInfo uriInfo) {
        ServiceOutcome statusCategoryOutcome = this.constantsService.getStatusCategoryById(this.authContext.getUser(), idOrKey);
        if (!statusCategoryOutcome.isValid() && !(statusCategoryOutcome = this.constantsService.getStatusCategoryByKey(this.authContext.getUser(), idOrKey)).isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(statusCategoryOutcome.getErrorCollection()));
        }
        return Response.ok((Object)this.statusCategoryHelper.createStatusCategoryBean((StatusCategory)statusCategoryOutcome.getReturnedValue(), uriInfo, StatusCategoryResource.class)).cacheControl(CacheControl.never()).build();
    }
}

