/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.issue.comparator.ConstantsComparator;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusJsonBean;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.StatusHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="status")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class StatusResource {
    private ConstantsService constantsService;
    private JiraAuthenticationContext authContext;
    private StatusHelper statusHelper;
    private JiraBaseUrls jiraBaseUrls;
    private StatusService statusService;

    private StatusResource() {
    }

    @Inject
    public StatusResource(JiraAuthenticationContext authContext, ConstantsService constantsService, StatusHelper statusHelper, JiraBaseUrls jiraBaseUrls, StatusService statusService) {
        this.authContext = authContext;
        this.constantsService = constantsService;
        this.statusHelper = statusHelper;
        this.jiraBaseUrls = jiraBaseUrls;
        this.statusService = statusService;
    }

    @GET
    public Response getStatuses(@Context Request request, @Context UriInfo uriInfo) {
        ServiceOutcome outcome = this.constantsService.getAllStatuses(this.authContext.getUser());
        if (!outcome.isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(outcome.getErrorCollection()));
        }
        Collection returnedValue = (Collection)outcome.getReturnedValue();
        ArrayList<StatusJsonBean> beans = new ArrayList<StatusJsonBean>(returnedValue.size());
        for (Status status : returnedValue) {
            StatusJsonBean statusBean = this.statusHelper.createStatusBean(status, uriInfo, StatusResource.class);
            beans.add(statusBean);
        }
        return Response.ok(beans).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{idOrName}")
    public Response getStatus(@PathParam(value="idOrName") String idOrName, @Context Request request, @Context UriInfo uriInfo) {
        ServiceOutcome statusOutcome = this.constantsService.getStatusById(this.authContext.getUser(), idOrName);
        if (!statusOutcome.isValid() && !(statusOutcome = this.constantsService.getStatusByTranslatedName(this.authContext.getUser(), idOrName)).isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(statusOutcome.getErrorCollection()));
        }
        return Response.ok((Object)this.statusHelper.createStatusBean((Status)statusOutcome.getReturnedValue(), uriInfo, StatusResource.class)).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="page")
    @Produces(value={"application/json"})
    @ExperimentalApi
    public Response getPaginatedStatuses(@DefaultValue(value="0") @QueryParam(value="startAt") Long startAt, @DefaultValue(value="100") @QueryParam(value="maxResults") Integer maxResults, @DefaultValue(value="") @QueryParam(value="query") String query, @QueryParam(value="projectIds") Set<Long> projectIds, @QueryParam(value="issueTypeIds") Set<String> issueTypeIds) {
        Set statuses = this.statusService.findStatuses(query, projectIds, issueTypeIds).collect(Collectors.toCollection(() -> new TreeSet(ConstantsComparator.COMPARATOR)));
        PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)maxResults);
        Page statusPage = Pages.toPage((Iterable)statuses, (PageRequest)pageRequest);
        PageBean<StatusJsonBean> bean = PageBean.from(pageRequest, statusPage).build(status -> StatusJsonBean.bean((Status)status, (JiraBaseUrls)this.jiraBaseUrls));
        return Response.ok(bean).cacheControl(CacheControl.never()).build();
    }
}

