/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.v2.issue.IssueInputParametersAssembler;
import com.atlassian.jira.rest.v2.issue.IssueUpdateBean;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import javax.inject.Inject;
import javax.ws.rs.core.Response;

public class UpdateIssueResource {
    private final IssueInputParametersAssembler issueInputParametersAssembler;
    private final IssueService issueService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionManager permissionManager;
    private final I18nHelper i18n;

    @Inject
    public UpdateIssueResource(IssueInputParametersAssembler issueInputParametersAssembler, IssueService issueService, JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager globalPermissionManager, PermissionManager permissionManager, I18nHelper i18n) {
        this.issueInputParametersAssembler = issueInputParametersAssembler;
        this.issueService = issueService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.permissionManager = permissionManager;
        this.i18n = i18n;
    }

    public Response editIssue(Issue issue, IssueUpdateBean updateRequest, boolean notifyUsers) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (!notifyUsers && !this.canDisableUserNotifications(user, issue)) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("update.issue.resource.not.enough.permissions.for.discarding.user.notification")));
        }
        IssueInputParametersAssembler.Result result = this.issueInputParametersAssembler.makeUpdateAssembler(updateRequest, issue);
        if (result.getErrors().hasAnyErrors()) {
            throw new BadRequestWebException(ErrorCollection.of(result.getErrors()));
        }
        IssueInputParameters inputParameters = result.getParameters();
        IssueService.UpdateValidationResult validation = this.issueService.validateUpdate(user, issue.getId(), inputParameters);
        if (!validation.isValid()) {
            throw new BadRequestWebException(ErrorCollection.of(validation.getErrorCollection()));
        }
        IssueService.IssueResult issueResult = this.issueService.update(user, validation, EventDispatchOption.ISSUE_UPDATED, notifyUsers);
        if (!issueResult.isValid()) {
            throw new BadRequestWebException(ErrorCollection.of(issueResult.getErrorCollection()));
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response transitionIssue(Issue issue, IssueUpdateBean issueUpdateBean) {
        IssueInputParametersAssembler.Result result = this.issueInputParametersAssembler.makeTransitionAssember(issueUpdateBean, issue);
        if (result.getErrors().hasAnyErrors()) {
            throw new BadRequestWebException(ErrorCollection.of(result.getErrors()));
        }
        IssueInputParameters inputParameters = result.getParameters();
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        IssueService.TransitionValidationResult validationResult = this.issueService.validateTransition(user, issue.getId(), Integer.valueOf(issueUpdateBean.getTransition().getId()).intValue(), inputParameters);
        if (!validationResult.isValid()) {
            throw new BadRequestWebException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        IssueService.IssueResult transitionResult = this.issueService.transition(user, validationResult);
        if (!transitionResult.isValid()) {
            throw new BadRequestWebException(ErrorCollection.of(transitionResult.getErrorCollection()));
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public boolean canDisableUserNotifications(ApplicationUser user, Issue issue) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, issue, user);
    }
}

