/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.builder;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataManager;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.rest.v2.issue.ChangelogBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class ChangelogBeanBuilder {
    private final ChangeHistoryManager changeHistoryManager;
    private final HistoryMetadataManager historyMetadataManager;
    private final JiraAuthenticationContext authContext;
    private final UserBeanFactory userBeanFactory;

    public ChangelogBeanBuilder(ChangeHistoryManager changeHistoryManager, HistoryMetadataManager historyMetadataManager, JiraAuthenticationContext authContext, UserBeanFactory userBeanFactory) {
        this.changeHistoryManager = changeHistoryManager;
        this.historyMetadataManager = historyMetadataManager;
        this.authContext = authContext;
        this.userBeanFactory = userBeanFactory;
    }

    private ChangelogBean.ChangeHistoryBean makeChangeHistoryBean(ChangeHistory changeHistory) {
        List items = Lists.transform((List)changeHistory.getChangeItemBeans(), (Function)new Function<ChangeItemBean, ChangelogBean.ChangeItemBean>(){

            public ChangelogBean.ChangeItemBean apply(ChangeItemBean from) {
                ChangelogBean.ChangeItemBean item = new ChangelogBean.ChangeItemBean();
                item.setField(from.getField());
                item.setFieldtype(from.getFieldType());
                item.setFrom(from.getFrom());
                item.setFromString(from.getFromString());
                item.setTo(from.getTo());
                item.setToString(from.getToString());
                return item;
            }
        });
        ChangelogBean.ChangeHistoryBean bean = new ChangelogBean.ChangeHistoryBean();
        ApplicationUser author = changeHistory.getAuthorObject();
        bean.setAuthor(this.userBeanFactory.createBean(author, this.authContext.getUser()));
        bean.setCreated(changeHistory.getTimePerformed());
        bean.setId(changeHistory.getId().toString());
        HistoryMetadataManager.HistoryMetadataResult historyMetadata = this.historyMetadataManager.getHistoryMetadata(changeHistory, this.authContext.getUser());
        if (historyMetadata.isValid() && historyMetadata.getHistoryMetadata() != null) {
            bean.setHistoryMetadata(historyMetadata.getHistoryMetadata());
        }
        bean.setItems(items);
        return bean;
    }

    public ChangelogBean build(Issue issue) {
        List allChangeHistories = this.changeHistoryManager.getChangeHistoriesForUser(issue, this.authContext.getUser());
        ArrayList histories = Lists.newArrayList();
        for (ChangeHistory changeHistoryItem : allChangeHistories) {
            histories.add(this.makeChangeHistoryBean(changeHistoryItem));
        }
        ChangelogBean changelog = new ChangelogBean();
        changelog.setStartAt(0);
        changelog.setMaxResults(histories.size());
        changelog.setTotal(histories.size());
        changelog.setHistories(histories);
        return changelog;
    }
}

