/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.groups;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.group.search.GroupPickerSearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.rest.v2.admin.GroupLabelBean;
import com.atlassian.jira.rest.v2.issue.GroupSuggestionBean;
import com.atlassian.jira.rest.v2.issue.GroupSuggestionsBean;
import com.atlassian.jira.rest.v2.issue.groups.GroupPickerResourceHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.DelimeterInserter;
import com.atlassian.jira.web.component.admin.group.GroupLabelView;
import com.atlassian.jira.web.component.admin.group.GroupLabelsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupPickerResourceHelperImpl
implements GroupPickerResourceHelper {
    public static final String MORE_GROUP_RESULTS_I18N_KEY = "jira.ajax.autocomplete.group.more.results";
    public static final int DEFAULT_MAX_RESULTS = 20;
    private static final Logger LOG = LoggerFactory.getLogger(GroupPickerResourceHelperImpl.class);
    private final ApplicationProperties applicationProperties;
    private final GroupPickerSearchService service;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final GroupLabelsService groupLabels;
    private final ApplicationRoleManager roleManager;
    private final UserManager userManager;

    @Autowired
    public GroupPickerResourceHelperImpl(GroupPickerSearchService service, JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, PermissionManager permissionManager, @ComponentImport GroupLabelsService groupLabels, @ComponentImport ApplicationRoleManager roleManager, @ComponentImport UserManager userManager) {
        this.service = service;
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.groupLabels = groupLabels;
        this.roleManager = roleManager;
        this.userManager = userManager;
    }

    @Override
    public GroupSuggestionsBean findGroupsAsBean(String query, List<String> excludeGroups, Integer maxResults, @Nullable String userName) {
        ArrayList groupBeans = Lists.newArrayList();
        List<Group> groups = Lists.newArrayList();
        if (excludeGroups == null) {
            excludeGroups = ImmutableList.of();
        }
        if (this.permissionManager.hasPermission(27, this.authenticationContext.getUser())) {
            groups = this.service.findGroups(query);
        } else {
            Group group = this.service.getGroupByName(query);
            if (group != null) {
                groups.add(group);
            }
        }
        ApplicationUser user = this.userManager.getUserByKeyEvenWhenUnknown(userName);
        int total = this.limitGroupResults(maxResults, groups, (List<String>)excludeGroups, groupBeans, query, user);
        String header = this.buildHeader(groupBeans, total);
        return new GroupSuggestionsBean(total, header, groupBeans);
    }

    private int limitGroupResults(Integer maxResults, List<Group> groups, List<String> excludeGroups, List<GroupSuggestionBean> groupBeans, String query, @Nullable ApplicationUser user) {
        int limit = this.getLimit(maxResults);
        int i = 0;
        int total = groups.size();
        for (Group group : groups) {
            if (i >= limit) break;
            if (!excludeGroups.contains(group.getName())) {
                Object groupLabels;
                String matchingHtml = this.buildMatchingHtml(group.getName(), query);
                if (this.permissionManager.hasPermission(0, this.authenticationContext.getLoggedInUser())) {
                    Optional directoryId = user != null ? Optional.of(user.getDirectoryId()) : Optional.empty();
                    groupLabels = this.groupLabels.getGroupLabels(group, directoryId);
                } else {
                    groupLabels = ImmutableList.of();
                }
                groupBeans.add(new GroupSuggestionBean(group.getName(), matchingHtml, GroupLabelBean.toLabelsBeansList((List<GroupLabelView>)groupLabels)));
                ++i;
                continue;
            }
            --total;
        }
        return total;
    }

    private int getLimit(Integer maxResults) {
        if (maxResults != null) {
            return maxResults;
        }
        int limit = 20;
        try {
            limit = Integer.valueOf(this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
        }
        catch (Exception nfe) {
            LOG.error("jira.ajax.autocomplete.limit does not exist or is an invalid number in jira-application.properties. Using default value 20", (Throwable)nfe);
        }
        return limit;
    }

    private String buildMatchingHtml(String group, String query) {
        DelimeterInserter delimeterInserter = new DelimeterInserter("<b>", "</b>", false);
        String matchingHtml = delimeterInserter.insert(TextUtils.htmlEncode((String)group), new String[]{query});
        return matchingHtml;
    }

    private String buildHeader(Collection<GroupSuggestionBean> groupBeans, int total) {
        return this.authenticationContext.getI18nHelper().getText(MORE_GROUP_RESULTS_I18N_KEY, String.valueOf(groupBeans.size()), String.valueOf(total));
    }
}

