/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.project;

import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

public class ProjectInputBean {
    public static final ProjectInputBean CREATE_EXAMPLE = ProjectInputBean.builder().setName("Example").setKey("EX").setDescription("Example Project description").setLeadName("Charlie").setUrl("http://atlassian.com").setAssigneeType(ProjectBean.AssigneeType.PROJECT_LEAD).setAvatarId(10200L).setIssueSecurityScheme(10001L).setPermissionScheme(10011L).setNotificationScheme(10021L).setWorkflowSchemeId(10031L).setCategoryId(10120L).setProjectTypeKey("business").setProjectTemplateKey("com.atlassian.jira-core-project-templates:jira-core-project-management").build();
    @JsonProperty
    private String key;
    @JsonProperty
    private String name;
    @JsonProperty
    private String projectTypeKey;
    @JsonProperty
    private String projectTemplateKey;
    @JsonProperty
    private String description;
    @JsonProperty
    private String lead;
    @JsonProperty
    private String url;
    @JsonProperty
    private ProjectBean.AssigneeType assigneeType;
    @JsonProperty
    private Long avatarId;
    @JsonProperty
    private Long issueSecurityScheme;
    @JsonProperty
    private Long permissionScheme;
    @JsonProperty
    private Long notificationScheme;
    @JsonProperty
    private Long workflowSchemeId;
    @JsonProperty
    private Long categoryId;

    public ProjectInputBean(String key, String name, String projectTypeKey, String projectTemplateKey, String description, String lead, String url, ProjectBean.AssigneeType assigneeType, Long avatarId, Long issueSecurityScheme, Long permissionScheme, Long notificationScheme, Long workflowSchemeId, Long categoryId) {
        this.key = key;
        this.name = name;
        this.projectTypeKey = projectTypeKey;
        this.projectTemplateKey = projectTemplateKey;
        this.description = description;
        this.lead = lead;
        this.url = url;
        this.assigneeType = assigneeType;
        this.avatarId = avatarId;
        this.issueSecurityScheme = issueSecurityScheme;
        this.permissionScheme = permissionScheme;
        this.notificationScheme = notificationScheme;
        this.categoryId = categoryId;
        this.workflowSchemeId = workflowSchemeId;
    }

    public ProjectInputBean() {
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getProjectTypeKey() {
        return this.projectTypeKey;
    }

    public String getProjectTemplateKey() {
        return this.projectTemplateKey;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLead() {
        return this.lead;
    }

    public String getUrl() {
        return this.url;
    }

    public ProjectBean.AssigneeType getAssigneeType() {
        return (ProjectBean.AssigneeType)((Object)MoreObjects.firstNonNull((Object)((Object)this.assigneeType), (Object)((Object)ProjectBean.AssigneeType.PROJECT_LEAD)));
    }

    @JsonIgnore
    public Long getAssigneeTypeOrNull() {
        return this.assigneeType != null ? Long.valueOf(this.assigneeType.getId()) : null;
    }

    public Long getAvatarId() {
        return this.avatarId;
    }

    public Long getIssueSecurityScheme() {
        return this.issueSecurityScheme;
    }

    public Long getPermissionScheme() {
        return this.permissionScheme;
    }

    public Long getNotificationScheme() {
        return this.notificationScheme;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public Long getWorkflowSchemeId() {
        return this.workflowSchemeId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String key;
        private String name;
        private String description;
        private String leadName;
        private String url;
        private ProjectBean.AssigneeType defaultAssignee;
        private Long avatarId;
        private Long issueSecurityScheme;
        private Long permissionScheme;
        private Long notificationScheme;
        private Long workflowSchemeId;
        private Long categoryId;
        private String projectTypeKey;
        private String projectTemplateKey;

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setLeadName(String leadName) {
            this.leadName = leadName;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setAssigneeType(ProjectBean.AssigneeType defaultAssignee) {
            this.defaultAssignee = defaultAssignee;
            return this;
        }

        public Builder setAvatarId(Long avatarId) {
            this.avatarId = avatarId;
            return this;
        }

        public Builder setIssueSecurityScheme(Long issueSecurityScheme) {
            this.issueSecurityScheme = issueSecurityScheme;
            return this;
        }

        public Builder setPermissionScheme(Long permissionScheme) {
            this.permissionScheme = permissionScheme;
            return this;
        }

        public Builder setNotificationScheme(Long notificationScheme) {
            this.notificationScheme = notificationScheme;
            return this;
        }

        public Builder setWorkflowSchemeId(Long workflowSchemeId) {
            this.workflowSchemeId = workflowSchemeId;
            return this;
        }

        public Builder setCategoryId(Long categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public Builder setProjectTypeKey(String projectTypeKey) {
            this.projectTypeKey = projectTypeKey;
            return this;
        }

        public Builder setProjectTemplateKey(String projectTemplateKey) {
            this.projectTemplateKey = projectTemplateKey;
            return this;
        }

        public ProjectInputBean build() {
            return new ProjectInputBean(this.key, this.name, this.projectTypeKey, this.projectTemplateKey, this.description, this.leadName, this.url, this.defaultAssignee, this.avatarId, this.issueSecurityScheme, this.permissionScheme, this.notificationScheme, this.workflowSchemeId, this.categoryId);
        }
    }
}

