/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.project;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.v2.issue.project.ProjectPicker;
import com.atlassian.jira.rest.v2.issue.project.ProjectPickerItem;
import com.atlassian.jira.rest.v2.issue.project.ProjectPickerResultWrapper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="projects/picker")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ProjectPickerResource {
    @VisibleForTesting
    static final String MORE_RESULTS_I18N_KEY = "jira.ajax.autocomplete.project.more.results";
    private static final int DEFAULT_MAX_LIMIT = 100;
    private final ProjectPicker projectPicker;
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    @Inject
    public ProjectPickerResource(ProjectPicker projectPicker, JiraAuthenticationContext authenticationContext) {
        this.projectPicker = projectPicker;
        this.authenticationContext = authenticationContext;
    }

    @GET
    public Response searchForProjects(@QueryParam(value="query") @DefaultValue(value="") String query, @QueryParam(value="maxResults") @DefaultValue(value="0") int maxResults, @QueryParam(value="allowEmptyQuery") @DefaultValue(value="false") boolean allowEmptyQuery) {
        List<ProjectPickerItem> matchedProjects = this.projectPicker.findProjects(query, allowEmptyQuery);
        int matchedProjectsCount = matchedProjects.size();
        int limit = ProjectPickerResource.resolveLimit(maxResults);
        List<ProjectPickerItem> matchingProjectEntries = matchedProjects.subList(0, Math.min(limit, matchedProjectsCount));
        ProjectPickerResultWrapper result = new ProjectPickerResultWrapper(matchingProjectEntries, matchedProjectsCount, this.getHeader(matchingProjectEntries.size(), matchedProjectsCount));
        return Response.ok((Object)result).cacheControl(CacheControl.never()).build();
    }

    private String getHeader(int currentSize, int maxSize) {
        return this.authenticationContext.getI18nHelper().getText(MORE_RESULTS_I18N_KEY, String.valueOf(currentSize), String.valueOf(maxSize));
    }

    private static int resolveLimit(int maxResults) {
        if (maxResults < 0) {
            return 0;
        }
        if (maxResults == 0) {
            return 100;
        }
        return Math.min(100, maxResults);
    }
}

