/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.worklog;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.issue.worklog.DeletedWorklog;
import com.atlassian.jira.bc.issue.worklog.WorklogChangedSincePage;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.issue.fields.rest.json.WorklogBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogJsonBean;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.issue.worklog.WorklogChangeBean;
import com.atlassian.jira.rest.v2.issue.worklog.WorklogChangedSinceBean;
import com.atlassian.jira.rest.v2.issue.worklog.WorklogIdsRequestBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

@Path(value="worklog")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class WorklogResource {
    private final ResponseFactory responseFactory;
    private final WorklogService worklogService;
    private final JiraAuthenticationContext authenticationContext;
    private final WorklogBeanFactory worklogBeanFactory;
    private final JiraBaseUrls jiraBaseUrls;

    @Inject
    public WorklogResource(ResponseFactory responseFactory, WorklogService worklogService, JiraAuthenticationContext authenticationContext, WorklogBeanFactory worklogBeanFactory, JiraBaseUrls jiraBaseUrls) {
        this.responseFactory = responseFactory;
        this.worklogService = worklogService;
        this.authenticationContext = authenticationContext;
        this.worklogBeanFactory = worklogBeanFactory;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @GET
    @Path(value="updated")
    public Response getIdsOfWorklogsModifiedSince(@QueryParam(value="since") @DefaultValue(value="0") Long since) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        WorklogChangedSincePage worklogsUpdatedSince = this.worklogService.getWorklogsUpdatedSince(user, since);
        WorklogChangedSinceBean worklogChangedSinceBean = this.createUpdatedSinceBean((WorklogChangedSincePage<Worklog>)worklogsUpdatedSince);
        return this.responseFactory.okNoCache(worklogChangedSinceBean);
    }

    @GET
    @Path(value="deleted")
    public Response getIdsOfWorklogsDeletedSince(@QueryParam(value="since") @DefaultValue(value="0") Long since) {
        WorklogChangedSincePage worklogsDeletedSince = this.worklogService.getWorklogsDeletedSince(this.authenticationContext.getLoggedInUser(), since);
        WorklogChangedSinceBean worklogChangedSinceBean = this.createDeletedSinceBean((WorklogChangedSincePage<DeletedWorklog>)worklogsDeletedSince);
        return this.responseFactory.okNoCache(worklogChangedSinceBean);
    }

    @POST
    @Path(value="list")
    public Response getWorklogsForIds(WorklogIdsRequestBean request) {
        final ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(loggedInUser, (ErrorCollection)new SimpleErrorCollection(), this.authenticationContext.getI18nHelper());
        if (request.getIds() == null) {
            return this.responseFactory.badRequest("worklog.rest.error.null.set", new String[0]);
        }
        final ServiceOutcome worklogsForIds = this.worklogService.getWorklogsForIds((JiraServiceContext)serviceContext, request.getIds());
        return (Response)this.responseFactory.validateOutcome(worklogsForIds).left().on((Function)new Function<Set<Worklog>, Response>(){

            @Override
            @Nullable
            public Response apply(Set<Worklog> worklogs) {
                return WorklogResource.this.responseFactory.okNoCache(((Set)worklogsForIds.get()).stream().map(new Function<Worklog, WorklogJsonBean>(){

                    @Override
                    public WorklogJsonBean apply(Worklog worklog) {
                        return WorklogResource.this.worklogBeanFactory.createBean(worklog, loggedInUser);
                    }
                }).collect(Collectors.toSet()));
            }
        });
    }

    private WorklogChangedSinceBean createUpdatedSinceBean(WorklogChangedSincePage<Worklog> updatedWorklogs) {
        return this.createChangeSinceBean("updated", updatedWorklogs, new Function<Worklog, Long>(){

            @Override
            public Long apply(Worklog worklog) {
                return worklog.getUpdated().getTime();
            }
        });
    }

    private WorklogChangedSinceBean createDeletedSinceBean(WorklogChangedSincePage<DeletedWorklog> worklogsDeletedSince) {
        return this.createChangeSinceBean("deleted", worklogsDeletedSince, new Function<DeletedWorklog, Long>(){

            @Override
            public Long apply(DeletedWorklog deletedWorklog) {
                return deletedWorklog.getDeletionTime().getTime();
            }
        });
    }

    private <T extends WithId> WorklogChangedSinceBean createChangeSinceBean(String restApiPath, WorklogChangedSincePage<T> changedSincePage, final Function<T, Long> timeMappingFunction) {
        Long since = changedSincePage.getSince();
        Long until = changedSincePage.getChangedSince().isEmpty() ? changedSincePage.getSince() : timeMappingFunction.apply(Iterables.getLast((Iterable)changedSincePage.getChangedSince()));
        List<WorklogChangeBean> changeBeans = changedSincePage.getChangedSince().stream().map(new Function<T, WorklogChangeBean>(){

            @Override
            public WorklogChangeBean apply(T t) {
                return new WorklogChangeBean(t.getId(), (Long)timeMappingFunction.apply(t));
            }
        }).collect(Collectors.toList());
        WorklogChangedSinceBean.Builder builder = WorklogChangedSinceBean.builder().setValues(changeBeans).setSince(since).setUntil(until).setIsLastPage(changedSincePage.isLastPage()).setSelf(this.getSelf(restApiPath, since));
        if (!changedSincePage.isLastPage()) {
            return builder.setNextPage(this.getSelf(restApiPath, until)).build();
        }
        return builder.build();
    }

    private URI getSelf(String restApiPath, Long since) {
        return UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path(WorklogResource.class).path(restApiPath).queryParam("since", new Object[]{since}).build(new Object[0]);
    }
}

