/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.monitoring;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.monitoring.IpdMonitoringControlService;
import com.atlassian.jira.rest.v2.monitoring.MonitoringController;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="monitoring/ipd")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IpdMonitoringController
extends MonitoringController {
    private final IpdMonitoringControlService ipdMonitoringMetricsService;

    @Inject
    public IpdMonitoringController(@Nonnull @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @Nonnull @ComponentImport GlobalPermissionManager permissionManager, @Nonnull @ComponentImport IpdMonitoringControlService ipdMonitoringMetricsService) {
        super(permissionManager, jiraAuthenticationContext);
        this.ipdMonitoringMetricsService = Objects.requireNonNull(ipdMonitoringMetricsService, "ipdMonitoringMetricsService");
    }

    @GET
    @WebSudoRequired
    public Response isIpdMonitoringEnabled() {
        return this.onlyAsAdmin(() -> Response.ok((Object)new IpdMonitoringRestEntity(this.ipdMonitoringMetricsService.isIpdMonitoringEnabled())).build());
    }

    @POST
    @WebSudoRequired
    public Response setAppMonitoringEnabled(@RequestBody IpdMonitoringRestEntity ipdMonitoringRequest) {
        return this.onlyAsAdmin(() -> {
            this.ipdMonitoringMetricsService.setIpdMonitoringEnabled(ipdMonitoringRequest.isEnabled().booleanValue());
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        });
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @VisibleForTesting
    public static class IpdMonitoringRestEntity {
        private Boolean isEnabled;

        public IpdMonitoringRestEntity(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public IpdMonitoringRestEntity() {
        }

        public void setEnabled(Boolean enabled) {
            this.isEnabled = enabled;
        }

        public Boolean isEnabled() {
            return this.isEnabled;
        }
    }
}

