/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.ofbiz.test;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.ofbiz.test.mock.MockSequenceUtil;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.exception.DataAccessException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.MemoryHelper;
import org.ofbiz.core.entity.SequenceUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import webwork.action.ActionContext;

public class UtilsForTests {
    public static GenericValue getTestEntity(String entity, Map fields) {
        try {
            return EntityUtils.createValue((String)entity, (Map)fields);
        }
        catch (DataAccessException e) {
            throw new EntityException((Exception)((Object)e));
        }
    }

    public static GenericValue getTestConstant(String entity, Map params) {
        try {
            if (params == null) {
                params = new HashMap<String, String>();
            }
            if (params.get("id") == null) {
                String id = EntityUtils.getNextStringId((String)entity);
                params.put("id", id);
            }
            GenericValue v = CoreFactory.getGenericDelegator().makeValue(entity, params);
            v = v.create();
            return v;
        }
        catch (GenericEntityException e) {
            throw new EntityException((Exception)((Object)e));
        }
    }

    public static void cleanWebWork() {
        ActionContext.setContext((ActionContext)new ActionContext());
    }

    public static void cleanOFBiz() {
        MemoryHelper.clearCache();
        String helperName = CoreFactory.getGenericDelegator().getEntityHelperName("SequenceValueItem");
        ModelEntity seqEntity = CoreFactory.getGenericDelegator().getModelEntity("SequenceValueItem");
        CoreFactory.getGenericDelegator().setSequencer((SequenceUtil)new MockSequenceUtil(helperName, seqEntity, "seqName", "seqId"));
    }

    public static void checkSingleElementCollection(Collection collection, Object expected) {
        Assert.assertEquals((long)1L, (long)collection.size());
        Assert.assertTrue((boolean)collection.contains(expected));
    }

    public static class EntityException
    extends RuntimeException {
        EntityException(Exception ex) {
            super(ex);
        }
    }
}

