/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.frontend.resources;

public class ExemptResource
implements Comparable<ExemptResource> {
    private static final String EXCEPTION_PATTERN = "([\\s|\\t]+)";
    private final String resourceName;
    private final boolean variable;

    public ExemptResource(String line) {
        String[] parts = line.split(EXCEPTION_PATTERN);
        this.resourceName = parts[0];
        this.variable = parts.length > 1 && Boolean.parseBoolean(parts[1]);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public boolean isVariable() {
        return this.variable;
    }

    public String toString() {
        return "ExemptResource{resourceName='" + this.resourceName + '\'' + '}';
    }

    @Override
    public int compareTo(ExemptResource o) {
        if (o == null) {
            return -1;
        }
        if (this.equals(o)) {
            return 0;
        }
        return this.getResourceName().compareToIgnoreCase(o.getResourceName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExemptResource that = (ExemptResource)o;
        if (this.variable != that.variable) {
            return false;
        }
        return this.resourceName != null ? this.resourceName.equals(that.resourceName) : that.resourceName == null;
    }

    public int hashCode() {
        int result = this.resourceName != null ? this.resourceName.hashCode() : 0;
        result = 31 * result + (this.variable ? 1 : 0);
        return result;
    }
}

