/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.help.HelpUrlsLoader;
import com.atlassian.jira.help.MockHelpUrls;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class MockHelpUrlsLoader
implements HelpUrlsLoader {
    private long currentId = 0L;
    private Map<Long, HelpUrls> urls = Maps.newHashMap();

    @Nonnull
    public HelpUrlsLoader.HelpUrlsLoaderKey keyForCurrentUser() {
        return new MockHelpUrlsLoaderKey(this.currentId);
    }

    @Nonnull
    public HelpUrlsLoader.HelpUrlsLoaderKey keyForApplication(@Nonnull ApplicationKey applicationKey) {
        return new MockHelpUrlsLoaderKey(this.currentId);
    }

    public HelpUrls apply(HelpUrlsLoader.HelpUrlsLoaderKey input) {
        if (input instanceof MockHelpUrlsLoaderKey) {
            return this.urls.get(((MockHelpUrlsLoaderKey)input).id);
        }
        throw new IllegalArgumentException();
    }

    public MockHelpUrlsLoader setCurrentId(long id) {
        this.currentId = id;
        return this;
    }

    public MockHelpUrls createUrls(MockHelpUrlsLoaderKey key) {
        MockHelpUrls result = new MockHelpUrls();
        this.urls.put(key.id, result);
        return result;
    }

    public MockHelpUrlsLoaderKey createKey(long id) {
        return new MockHelpUrlsLoaderKey(id);
    }

    public static class MockHelpUrlsLoaderKey
    implements HelpUrlsLoader.HelpUrlsLoaderKey {
        private final long id;

        public MockHelpUrlsLoaderKey(long id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MockHelpUrlsLoaderKey that = (MockHelpUrlsLoaderKey)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("id", this.id).toString();
        }
    }
}

