/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.local.listener;

import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public class StatsGatheringRunListener
extends RunListener {
    private static final int SLOW_TEST_THRESHOLD = 100;
    private Map<String, TestInfo> tests = new HashMap<String, TestInfo>();
    private Map<String, TestInfo> slowTests = new HashMap<String, TestInfo>();
    private Map<String, TestInfo> ignoredTests = new HashMap<String, TestInfo>();
    private List<Long> runTimes = new ArrayList<Long>();
    private long slowTestTime = 0L;
    private long legacyMockTestTime = 0L;
    private long legacyMockTestCount = 0L;

    private static String makeName(Description description) {
        Class clazz = description.getTestClass();
        String methodName = description.getMethodName();
        if (clazz != null && StringUtils.isNotBlank((CharSequence)methodName)) {
            return clazz.getSimpleName() + "." + methodName;
        }
        return description.getDisplayName();
    }

    private float pct(long total, long of) {
        return (float)of / (float)total * 100.0f;
    }

    public void testRunFinished(Result result) throws Exception {
        String dumpStats = System.getProperty("unit.test.dumpstats");
        if (dumpStats == null || !Boolean.valueOf(dumpStats).booleanValue()) {
            return;
        }
        System.out.flush();
        this.heading("UNIT TEST RUN INFORMATION");
        long totalRunTime = result.getRunTime();
        System.out.printf("Tests Run                        : %d\n", result.getRunCount());
        System.out.printf("Tests Run Time                   : %d seconds\n", totalRunTime / 1000L);
        System.out.printf("Average Run Time                 : %.2f ms\n", Float.valueOf((float)totalRunTime / (float)result.getRunCount()));
        System.out.printf("Median Run Time                  : %d ms\n", StatsGatheringRunListener.findMedian(this.runTimes));
        System.out.printf("Tests Failures                   : %d\n", result.getFailureCount());
        System.out.printf("LegacyJiraMockTestCase Instances : %d\n", this.legacyMockTestCount);
        System.out.printf("LegacyJiraMockTestCase Time      : %d seconds /  %.2f%%\n", this.legacyMockTestTime / 1000L, Float.valueOf(this.pct(totalRunTime, this.legacyMockTestTime)));
        List<TestInfo> slowTests = this.calculateSlowTests();
        int slowCount = slowTests.size();
        if (slowCount > 0) {
            this.heading("The following tests are considered SLOW (ie. > 100ms)");
            System.out.printf("\tTotal :  %d tests /  %.2f%%\n", slowCount, Float.valueOf(this.pct(result.getRunCount(), slowCount)));
            System.out.printf("\tTime  :  %d seconds /  %.2f%%\n", this.slowTestTime / 1000L, Float.valueOf(this.pct(totalRunTime, this.slowTestTime)));
            System.out.printf("\n", new Object[0]);
            for (TestInfo slowTest : slowTests) {
                System.out.printf("\t %s \t%dms\n", this.pad100(slowTest.description), slowTest.runTime);
            }
        }
        if (!this.ignoredTests.isEmpty()) {
            this.heading("The following tests are IGNORED");
            for (TestInfo testInfo : this.ignoredTests.values()) {
                System.out.printf("\t %s\n", testInfo.description);
            }
        }
    }

    private String pad100(Object o) {
        return StringUtils.rightPad((String)String.valueOf(o), (int)100);
    }

    private static long findMedian(List<Long> data) {
        Long result;
        Collections.sort(data);
        int size = data.size();
        if (size % 2 == 1) {
            result = data.get((int)Math.floor(size / 2));
        } else {
            Long lowerMiddle = data.get(size / 2);
            Long upperMiddle = data.get(size / 2 - 1);
            result = (lowerMiddle + upperMiddle) / 2L;
        }
        return result;
    }

    private void heading(String msg) {
        System.out.printf("\n\n------------------------------------------------------------------------------------------\n%s\n------------------------------------------------------------------------------------------\n", msg);
    }

    private List<TestInfo> calculateSlowTests() {
        ArrayList<TestInfo> list = new ArrayList<TestInfo>(this.slowTests.values());
        Collections.sort(list);
        return list;
    }

    public void testStarted(Description description) throws Exception {
        this.tests.put(StatsGatheringRunListener.makeName(description), new TestInfo(description));
    }

    public void testFinished(Description description) throws Exception {
        String name = StatsGatheringRunListener.makeName(description);
        TestInfo testInfo = (TestInfo)Assertions.notNull((String)"testInfo", (Object)this.tests.get(name));
        long runTime = testInfo.snapshotRunTime();
        this.runTimes.add(runTime);
        if (runTime > 100L) {
            this.slowTests.put(name, testInfo);
            this.slowTestTime += runTime;
        }
        this.tests.remove(name);
        this.calculateBadTestCount(description, runTime);
    }

    private void calculateBadTestCount(Description description, long runTime) {
    }

    public void testIgnored(Description description) throws Exception {
        String name;
        TestInfo testInfo = this.tests.get(name = StatsGatheringRunListener.makeName(description));
        this.ignoredTests.put(name, testInfo == null ? new TestInfo(description) : testInfo);
    }

    private static class TestInfo
    implements Comparable {
        private final long startTime;
        private long runTime;
        private final String description;

        private TestInfo(Description description) {
            this.description = StatsGatheringRunListener.makeName(description);
            this.startTime = System.currentTimeMillis();
        }

        private long snapshotRunTime() {
            this.runTime = System.currentTimeMillis() - this.startTime;
            return this.runTime;
        }

        public int compareTo(Object o) {
            return this.compareTo((TestInfo)o);
        }

        public int compareTo(TestInfo that) {
            long rc = that.runTime - this.runTime;
            if (rc == 0L) {
                return this.description.compareTo(that.description);
            }
            return rc > 0L ? 1 : -1;
        }
    }
}

