/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers.auditing;

import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ChangedValueMatcher
extends TypeSafeMatcher<ChangedValue> {
    private final String key;
    private final String from;
    private final String to;

    public ChangedValueMatcher(@Nullable String key, @Nullable String from, @Nullable String to) {
        this.key = key;
        this.from = from;
        this.to = to;
    }

    protected boolean matchesSafely(ChangedValue changedValue) {
        return Objects.equals(this.key, changedValue.getI18nKey()) && Objects.equals(this.from, changedValue.getFrom()) && Objects.equals(this.to, changedValue.getTo());
    }

    public void describeTo(Description description) {
        description.appendText(AuditEntitiesUtils.newChangedValue((String)this.key, (String)this.from, (String)this.to).toString());
    }

    @Factory
    public static BaseMatcher<ChangedValue> changedValue(@Nonnull String key, @Nullable String from, @Nullable String to) {
        return new ChangedValueMatcher(key, from, to);
    }

    @Factory
    public static BaseMatcher<ChangedValue> changedValue(@Nonnull String key, @Nonnull String to) {
        return ChangedValueMatcher.changedValue(key, null, to);
    }

    @Factory
    public static BaseMatcher<ChangedValue> withFrom(Matcher<CharSequence> itemMatcher) {
        return new FeatureMatcher<ChangedValue, CharSequence>(itemMatcher, "from to be", "from"){

            protected String featureValueOf(ChangedValue actual) {
                return actual.getFrom();
            }
        };
    }
}

