/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.component;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.DatabaseConfigurationService;
import com.atlassian.jira.config.MockDatabaseConfigurationService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.jql.builder.JqlClauseBuilderFactory;
import com.atlassian.jira.jql.builder.JqlClauseBuilderFactoryImpl;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.util.JqlDateSupportImpl;
import com.atlassian.jira.mock.MockApplicationProperties;
import com.atlassian.jira.user.MockUserKeyService;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.preferences.MockUserPreferencesManager;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.google.common.collect.Maps;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockComponentWorker
implements ComponentAccessor.Worker {
    private static final Logger LOG = LoggerFactory.getLogger(MockComponentWorker.class);
    final Map<Class<?>, Object> implementations = Maps.newHashMap();
    final Map<Class<?>, LazyReference<?>> lazyImplementationReferences = Maps.newHashMap();
    private MockUserPreferencesManager mockUserPreferences;
    private MockApplicationProperties mockApplicationProperties;
    private MockUserKeyService mockUserKeyService;
    private MockDatabaseConfigurationService mockDatabaseConfigurationService;

    public MockComponentWorker() {
        this.initDefaultMocks();
    }

    private void initDefaultMocks() {
        this.mockUserPreferences = new MockUserPreferencesManager();
        this.mockApplicationProperties = new MockApplicationProperties();
        this.mockUserKeyService = new MockUserKeyService();
        this.mockDatabaseConfigurationService = new MockDatabaseConfigurationService();
        this.registerMock(UserKeyService.class, this.mockUserKeyService);
        this.registerMock(UserPreferencesManager.class, this.mockUserPreferences);
        this.registerMock(ApplicationProperties.class, this.mockApplicationProperties);
        this.registerMock(DatabaseConfigurationService.class, this.mockDatabaseConfigurationService);
        this.addMock(JqlClauseBuilderFactory.class, new LazyReference<JqlClauseBuilderFactory>(){

            protected JqlClauseBuilderFactory create() {
                return new JqlClauseBuilderFactoryImpl((JqlDateSupport)new JqlDateSupportImpl(null));
            }
        });
    }

    public <T, U extends T> void registerMock(Class<T> componentInterface, U componentMock) {
        this.implementations.put(componentInterface, componentMock);
    }

    public <T, U extends T> MockComponentWorker addMock(Class<T> componentInterface, U componentMock) {
        this.registerMock(componentInterface, componentMock);
        return this;
    }

    public <T, U extends T> MockComponentWorker addMock(Class<T> componentInterface, LazyReference<U> componentMockRef) {
        this.lazyImplementationReferences.put(componentInterface, componentMockRef);
        return this;
    }

    public <T> Optional<T> getComponentSafely(Class<T> componentClass) {
        return Optional.ofNullable(this.getComponent(componentClass));
    }

    public <T> T getComponent(Class<T> componentClass) {
        LazyReference<?> lazyReference;
        Object component = this.implementations.get(componentClass);
        if (component == null && (lazyReference = this.lazyImplementationReferences.get(componentClass)) != null) {
            component = lazyReference.get();
        }
        if (component == null) {
            LOG.warn("No mock implementation was provided for component '" + componentClass.getName() + '\'');
        }
        return componentClass.cast(component);
    }

    public <T> T getComponentOfType(Class<T> componentClass) {
        return this.getComponent(componentClass);
    }

    public <T> T getOSGiComponentInstanceOfType(Class<T> componentClass) {
        return this.getComponent(componentClass);
    }

    public MockComponentWorker init() {
        ComponentAccessor.initialiseWorker((ComponentAccessor.Worker)this);
        return this;
    }

    public MockUserPreferencesManager getMockUserPreferences() {
        return this.mockUserPreferences;
    }

    public MockApplicationProperties getMockApplicationProperties() {
        return this.mockApplicationProperties;
    }

    public MockUserKeyService getMockUserKeyService() {
        return this.mockUserKeyService;
    }

    public MockDatabaseConfigurationService getMockDatabaseConfigurationService() {
        return this.mockDatabaseConfigurationService;
    }
}

