/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.event;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventListener;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.mock.MockListenerManager;
import com.atlassian.jira.mock.event.MockListener;
import java.util.ArrayList;
import java.util.Collection;

public class MockIssueEventListener
extends MockListener
implements IssueEventListener {
    Collection<Object[]> calls = new ArrayList<Object[]>(4);

    public MockIssueEventListener(MockListenerManager mlm) {
        mlm.addListener("mock", this);
    }

    public void issueCreated(IssueEvent event) {
        this.calls.add(new Object[]{"issueCreated", event});
    }

    public void issueUpdated(IssueEvent event) {
        throw new UnsupportedOperationException();
    }

    public void issueAssigned(IssueEvent event) {
        this.calls.add(new Object[]{"issueAssigned", event});
    }

    public void issueResolved(IssueEvent event) {
        this.calls.add(new Object[]{"issueResolved", event});
    }

    public void issueClosed(IssueEvent event) {
        this.calls.add(new Object[]{"issueClosed", event});
    }

    public void issueCommented(IssueEvent event) {
        throw new UnsupportedOperationException();
    }

    public void issueReopened(IssueEvent event) {
        this.calls.add(new Object[]{"issueReopened", event});
    }

    public void issueDeleted(IssueEvent event) {
        this.calls.add(new Object[]{"issueDeleted", event});
    }

    public void issueMoved(IssueEvent event) {
        this.calls.add(new Object[]{"issueMoved", event});
    }

    public void issueWorkLogged(IssueEvent event) {
        throw new UnsupportedOperationException();
    }

    public Collection<Object[]> getCalls() {
        return this.calls;
    }

    public void issueStarted(IssueEvent event) {
        this.calls.add(new Object[]{"issueStarted", event});
    }

    public void issueStopped(IssueEvent event) {
        this.calls.add(new Object[]{"issueStopped", event});
    }

    public void issueGenericEvent(IssueEvent event) {
        this.calls.add(new Object[]{"issueGenericEvent", event});
    }

    public void workflowEvent(IssueEvent event) {
        Long eventTypeId;
        EventTypeManager eventTypeManager = ComponentAccessor.getEventTypeManager();
        EventType eventType = eventTypeManager.getEventType(eventTypeId = event.getEventTypeId());
        if (eventType == null) {
            throw new RuntimeException("Event Type with ID '" + eventTypeId + "' is not recognised.");
        }
        if (eventTypeId.equals(EventType.ISSUE_CREATED_ID)) {
            this.issueCreated(event);
        } else if (eventTypeId.equals(EventType.ISSUE_UPDATED_ID)) {
            this.issueUpdated(event);
        } else if (eventTypeId.equals(EventType.ISSUE_ASSIGNED_ID)) {
            this.issueAssigned(event);
        } else if (eventTypeId.equals(EventType.ISSUE_RESOLVED_ID)) {
            this.issueResolved(event);
        } else if (eventTypeId.equals(EventType.ISSUE_COMMENTED_ID)) {
            this.issueCommented(event);
        } else if (eventTypeId.equals(EventType.ISSUE_CLOSED_ID)) {
            this.issueClosed(event);
        } else if (eventTypeId.equals(EventType.ISSUE_REOPENED_ID)) {
            this.issueReopened(event);
        } else if (eventTypeId.equals(EventType.ISSUE_DELETED_ID)) {
            this.issueDeleted(event);
        } else if (eventTypeId.equals(EventType.ISSUE_MOVED_ID)) {
            this.issueMoved(event);
        } else if (eventTypeId.equals(EventType.ISSUE_WORKLOGGED_ID)) {
            this.issueWorkLogged(event);
        } else if (eventTypeId.equals(EventType.ISSUE_WORKSTARTED_ID)) {
            this.issueStarted(event);
        } else if (eventTypeId.equals(EventType.ISSUE_WORKSTOPPED_ID)) {
            this.issueStopped(event);
        } else if (eventTypeId.equals(EventType.ISSUE_GENERICEVENT_ID)) {
            this.issueGenericEvent(event);
        } else {
            this.customEvent(event);
        }
    }

    public void customEvent(IssueEvent event) {
        this.calls.add(new Object[]{"customEvent", event});
    }
}

